; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx950 < %s | FileCheck -check-prefix=GCN %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx950 < %s | FileCheck -check-prefix=GCN %s

; RUN: not --crash llc -global-isel=0 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx940 -filetype=null %s 2>&1 | FileCheck -check-prefix=ERR-SDAG %s
; RUN: not --crash llc -global-isel=1 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx940 -filetype=null %s 2>&1 | FileCheck -check-prefix=ERR-GISEL %s

; ERR-SDAG: LLVM ERROR: Cannot select: intrinsic %llvm.amdgcn.permlane16.swap
; ERR-GISEL: LLVM ERROR: cannot select: %{{[0-9]+}}:vgpr_32(s32), %{{[0-9]+}}:vgpr_32(s32) = G_INTRINSIC_CONVERGENT intrinsic(@llvm.amdgcn.permlane16.swap)


declare { i32, i32 } @llvm.amdgcn.permlane16.swap(i32, i32, i1 immarg, i1 immarg)

define { i32, i32 } @v_permlane16_swap_b32_vv(i32 %vdst_old, i32 %src0_old) {
; GCN-LABEL: v_permlane16_swap_b32_vv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_permlane16_swap_b32_e32 v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %v = call { i32, i32 } @llvm.amdgcn.permlane16.swap(i32 %vdst_old, i32 %src0_old, i1 false, i1 false)
  ret { i32, i32 } %v
}

define { i32, i32 } @v_permlane16_swap_b32_vi(i32 %vdst_old) {
; GCN-LABEL: v_permlane16_swap_b32_vi:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v1, 1
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_permlane16_swap_b32_e32 v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %v = call { i32, i32 } @llvm.amdgcn.permlane16.swap(i32 %vdst_old, i32 1, i1 false, i1 false)
  ret { i32, i32 } %v
}

define { i32, i32 } @v_permlane16_swap_b32_vl(i32 %vdst_old) {
; GCN-LABEL: v_permlane16_swap_b32_vl:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v1, 0xc1d1
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_permlane16_swap_b32_e32 v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %v = call { i32, i32 } @llvm.amdgcn.permlane16.swap(i32 %vdst_old, i32 49617, i1 false, i1 false)
  ret { i32, i32 } %v
}

define { i32, i32 } @v_permlane16_swap_b32_iv(i32 %src0_old) {
; GCN-LABEL: v_permlane16_swap_b32_iv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v1, v0
; GCN-NEXT:    v_mov_b32_e32 v0, 1
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_permlane16_swap_b32_e32 v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %v = call { i32, i32 } @llvm.amdgcn.permlane16.swap(i32 1, i32 %src0_old, i1 false, i1 false)
  ret { i32, i32 } %v
}

define { i32, i32 } @v_permlane16_swap_b32_ss(i32 inreg %vdst_old, i32 inreg %src0_old) {
; GCN-LABEL: v_permlane16_swap_b32_ss:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_permlane16_swap_b32_e32 v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %v = call { i32, i32 } @llvm.amdgcn.permlane16.swap(i32 %vdst_old, i32 %src0_old, i1 false, i1 false)
  ret { i32, i32 } %v
}

define { i32, i32 } @v_permlane16_swap_b32_sv(i32 inreg %vdst_old, i32 %src0_old) {
; GCN-LABEL: v_permlane16_swap_b32_sv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v1, v0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_permlane16_swap_b32_e32 v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %v = call { i32, i32 } @llvm.amdgcn.permlane16.swap(i32 %vdst_old, i32 %src0_old, i1 false, i1 false)
  ret { i32, i32 } %v
}

define { i32, i32 } @v_permlane16_swap_b32_vs(i32 %vdst_old, i32 inreg %src0_old) {
; GCN-LABEL: v_permlane16_swap_b32_vs:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v1, s0
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_permlane16_swap_b32_e32 v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %v = call { i32, i32 } @llvm.amdgcn.permlane16.swap(i32 %vdst_old, i32 %src0_old, i1 false, i1 false)
  ret { i32, i32 } %v
}

define { i32, i32 } @v_permlane16_swap_b32_vv_fi(i32 %vdst_old, i32 %src0_old) {
; GCN-LABEL: v_permlane16_swap_b32_vv_fi:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_permlane16_swap_b32_e64 v0, v1 fi:1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %v = call { i32, i32 } @llvm.amdgcn.permlane16.swap(i32 %vdst_old, i32 %src0_old, i1 true, i1 false)
  ret { i32, i32 } %v
}

define { i32, i32 } @v_permlane16_swap_b32_vv_bc(i32 %vdst_old, i32 %src0_old) {
; GCN-LABEL: v_permlane16_swap_b32_vv_bc:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_permlane16_swap_b32_e64 v0, v1 bound_ctrl:1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %v = call { i32, i32 } @llvm.amdgcn.permlane16.swap(i32 %vdst_old, i32 %src0_old, i1 false, i1 true)
  ret { i32, i32 } %v
}

define { i32, i32 } @v_permlane16_swap_b32_vv_fi_bc(i32 %vdst_old, i32 %src0_old) {
; GCN-LABEL: v_permlane16_swap_b32_vv_fi_bc:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_permlane16_swap_b32_e64 v0, v1 bound_ctrl:1 fi:1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %v = call { i32, i32 } @llvm.amdgcn.permlane16.swap(i32 %vdst_old, i32 %src0_old, i1 true, i1 true)
  ret { i32, i32 } %v
}
