; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -mtriple=x86_64-unknown -passes=slp-vectorizer -S | FileCheck %s --check-prefix=CHECK --check-prefix=SSE
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=corei7-avx -passes=slp-vectorizer -S | FileCheck %s --check-prefix=CHECK --check-prefix=AVX
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=core-avx2 -passes=slp-vectorizer -S | FileCheck %s --check-prefix=CHECK --check-prefix=AVX
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=bdver2 -passes=slp-vectorizer -S | FileCheck %s --check-prefix=CHECK --check-prefix=XOP
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=bdver4 -passes=slp-vectorizer -S | FileCheck %s --check-prefix=CHECK --check-prefix=XOP

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

@src64 = common global [4 x i64] zeroinitializer, align 32
@dst64 = common global [4 x i64] zeroinitializer, align 32
@src32 = common global [8 x i32] zeroinitializer, align 32
@dst32 = common global [8 x i32] zeroinitializer, align 32
@src16 = common global [16 x i16] zeroinitializer, align 32
@dst16 = common global [16 x i16] zeroinitializer, align 32
@src8  = common global [32 x i8] zeroinitializer, align 32
@dst8  = common global [32 x i8] zeroinitializer, align 32

declare i64 @llvm.bitreverse.i64(i64)
declare i32 @llvm.bitreverse.i32(i32)
declare i16 @llvm.bitreverse.i16(i16)
declare  i8 @llvm.bitreverse.i8(i8)

define void @bitreverse_2i64() #0 {
; CHECK-LABEL: @bitreverse_2i64(
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @src64, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> [[TMP1]])
; CHECK-NEXT:    store <2 x i64> [[TMP2]], ptr @dst64, align 8
; CHECK-NEXT:    ret void
;
  %ld0 = load i64, ptr @src64, align 8
  %ld1 = load i64, ptr getelementptr inbounds ([4 x i64], ptr @src64, i32 0, i64 1), align 8
  %bitreverse0 = call i64 @llvm.bitreverse.i64(i64 %ld0)
  %bitreverse1 = call i64 @llvm.bitreverse.i64(i64 %ld1)
  store i64 %bitreverse0, ptr @dst64, align 8
  store i64 %bitreverse1, ptr getelementptr inbounds ([4 x i64], ptr @dst64, i32 0, i64 1), align 8
  ret void
}

define void @bitreverse_4i64() #0 {
; SSE-LABEL: @bitreverse_4i64(
; SSE-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @src64, align 4
; SSE-NEXT:    [[TMP2:%.*]] = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> [[TMP1]])
; SSE-NEXT:    store <2 x i64> [[TMP2]], ptr @dst64, align 4
; SSE-NEXT:    [[TMP3:%.*]] = load <2 x i64>, ptr getelementptr inbounds ([4 x i64], ptr @src64, i64 0, i64 2), align 4
; SSE-NEXT:    [[TMP4:%.*]] = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> [[TMP3]])
; SSE-NEXT:    store <2 x i64> [[TMP4]], ptr getelementptr inbounds ([4 x i64], ptr @dst64, i64 0, i64 2), align 4
; SSE-NEXT:    ret void
;
; AVX-LABEL: @bitreverse_4i64(
; AVX-NEXT:    [[TMP1:%.*]] = load <4 x i64>, ptr @src64, align 4
; AVX-NEXT:    [[TMP2:%.*]] = call <4 x i64> @llvm.bitreverse.v4i64(<4 x i64> [[TMP1]])
; AVX-NEXT:    store <4 x i64> [[TMP2]], ptr @dst64, align 4
; AVX-NEXT:    ret void
;
; XOP-LABEL: @bitreverse_4i64(
; XOP-NEXT:    [[TMP1:%.*]] = load <4 x i64>, ptr @src64, align 4
; XOP-NEXT:    [[TMP2:%.*]] = call <4 x i64> @llvm.bitreverse.v4i64(<4 x i64> [[TMP1]])
; XOP-NEXT:    store <4 x i64> [[TMP2]], ptr @dst64, align 4
; XOP-NEXT:    ret void
;
  %ld0 = load i64, ptr @src64, align 4
  %ld1 = load i64, ptr getelementptr inbounds ([4 x i64], ptr @src64, i64 0, i64 1), align 4
  %ld2 = load i64, ptr getelementptr inbounds ([4 x i64], ptr @src64, i64 0, i64 2), align 4
  %ld3 = load i64, ptr getelementptr inbounds ([4 x i64], ptr @src64, i64 0, i64 3), align 4
  %bitreverse0 = call i64 @llvm.bitreverse.i64(i64 %ld0)
  %bitreverse1 = call i64 @llvm.bitreverse.i64(i64 %ld1)
  %bitreverse2 = call i64 @llvm.bitreverse.i64(i64 %ld2)
  %bitreverse3 = call i64 @llvm.bitreverse.i64(i64 %ld3)
  store i64 %bitreverse0, ptr @dst64, align 4
  store i64 %bitreverse1, ptr getelementptr inbounds ([4 x i64], ptr @dst64, i64 0, i64 1), align 4
  store i64 %bitreverse2, ptr getelementptr inbounds ([4 x i64], ptr @dst64, i64 0, i64 2), align 4
  store i64 %bitreverse3, ptr getelementptr inbounds ([4 x i64], ptr @dst64, i64 0, i64 3), align 4
  ret void
}

define void @bitreverse_4i32() #0 {
; CHECK-LABEL: @bitreverse_4i32(
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @src32, align 4
; CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> [[TMP1]])
; CHECK-NEXT:    store <4 x i32> [[TMP2]], ptr @dst32, align 4
; CHECK-NEXT:    ret void
;
  %ld0 = load i32, ptr @src32, align 4
  %ld1 = load i32, ptr getelementptr inbounds ([8 x i32], ptr @src32, i32 0, i64 1), align 4
  %ld2 = load i32, ptr getelementptr inbounds ([8 x i32], ptr @src32, i32 0, i64 2), align 4
  %ld3 = load i32, ptr getelementptr inbounds ([8 x i32], ptr @src32, i32 0, i64 3), align 4
  %bitreverse0 = call i32 @llvm.bitreverse.i32(i32 %ld0)
  %bitreverse1 = call i32 @llvm.bitreverse.i32(i32 %ld1)
  %bitreverse2 = call i32 @llvm.bitreverse.i32(i32 %ld2)
  %bitreverse3 = call i32 @llvm.bitreverse.i32(i32 %ld3)
  store i32 %bitreverse0, ptr @dst32, align 4
  store i32 %bitreverse1, ptr getelementptr inbounds ([8 x i32], ptr @dst32, i32 0, i64 1), align 4
  store i32 %bitreverse2, ptr getelementptr inbounds ([8 x i32], ptr @dst32, i32 0, i64 2), align 4
  store i32 %bitreverse3, ptr getelementptr inbounds ([8 x i32], ptr @dst32, i32 0, i64 3), align 4
  ret void
}

define void @bitreverse_8i32() #0 {
; SSE-LABEL: @bitreverse_8i32(
; SSE-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @src32, align 2
; SSE-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> [[TMP1]])
; SSE-NEXT:    store <4 x i32> [[TMP2]], ptr @dst32, align 2
; SSE-NEXT:    [[TMP3:%.*]] = load <4 x i32>, ptr getelementptr inbounds ([8 x i32], ptr @src32, i32 0, i64 4), align 2
; SSE-NEXT:    [[TMP4:%.*]] = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> [[TMP3]])
; SSE-NEXT:    store <4 x i32> [[TMP4]], ptr getelementptr inbounds ([8 x i32], ptr @dst32, i32 0, i64 4), align 2
; SSE-NEXT:    ret void
;
; AVX-LABEL: @bitreverse_8i32(
; AVX-NEXT:    [[TMP1:%.*]] = load <8 x i32>, ptr @src32, align 2
; AVX-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.bitreverse.v8i32(<8 x i32> [[TMP1]])
; AVX-NEXT:    store <8 x i32> [[TMP2]], ptr @dst32, align 2
; AVX-NEXT:    ret void
;
; XOP-LABEL: @bitreverse_8i32(
; XOP-NEXT:    [[TMP1:%.*]] = load <8 x i32>, ptr @src32, align 2
; XOP-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.bitreverse.v8i32(<8 x i32> [[TMP1]])
; XOP-NEXT:    store <8 x i32> [[TMP2]], ptr @dst32, align 2
; XOP-NEXT:    ret void
;
  %ld0 = load i32, ptr @src32, align 2
  %ld1 = load i32, ptr getelementptr inbounds ([8 x i32], ptr @src32, i32 0, i64 1), align 2
  %ld2 = load i32, ptr getelementptr inbounds ([8 x i32], ptr @src32, i32 0, i64 2), align 2
  %ld3 = load i32, ptr getelementptr inbounds ([8 x i32], ptr @src32, i32 0, i64 3), align 2
  %ld4 = load i32, ptr getelementptr inbounds ([8 x i32], ptr @src32, i32 0, i64 4), align 2
  %ld5 = load i32, ptr getelementptr inbounds ([8 x i32], ptr @src32, i32 0, i64 5), align 2
  %ld6 = load i32, ptr getelementptr inbounds ([8 x i32], ptr @src32, i32 0, i64 6), align 2
  %ld7 = load i32, ptr getelementptr inbounds ([8 x i32], ptr @src32, i32 0, i64 7), align 2
  %bitreverse0 = call i32 @llvm.bitreverse.i32(i32 %ld0)
  %bitreverse1 = call i32 @llvm.bitreverse.i32(i32 %ld1)
  %bitreverse2 = call i32 @llvm.bitreverse.i32(i32 %ld2)
  %bitreverse3 = call i32 @llvm.bitreverse.i32(i32 %ld3)
  %bitreverse4 = call i32 @llvm.bitreverse.i32(i32 %ld4)
  %bitreverse5 = call i32 @llvm.bitreverse.i32(i32 %ld5)
  %bitreverse6 = call i32 @llvm.bitreverse.i32(i32 %ld6)
  %bitreverse7 = call i32 @llvm.bitreverse.i32(i32 %ld7)
  store i32 %bitreverse0, ptr @dst32, align 2
  store i32 %bitreverse1, ptr getelementptr inbounds ([8 x i32], ptr @dst32, i32 0, i64 1), align 2
  store i32 %bitreverse2, ptr getelementptr inbounds ([8 x i32], ptr @dst32, i32 0, i64 2), align 2
  store i32 %bitreverse3, ptr getelementptr inbounds ([8 x i32], ptr @dst32, i32 0, i64 3), align 2
  store i32 %bitreverse4, ptr getelementptr inbounds ([8 x i32], ptr @dst32, i32 0, i64 4), align 2
  store i32 %bitreverse5, ptr getelementptr inbounds ([8 x i32], ptr @dst32, i32 0, i64 5), align 2
  store i32 %bitreverse6, ptr getelementptr inbounds ([8 x i32], ptr @dst32, i32 0, i64 6), align 2
  store i32 %bitreverse7, ptr getelementptr inbounds ([8 x i32], ptr @dst32, i32 0, i64 7), align 2
  ret void
}

define void @bitreverse_8i16() #0 {
; CHECK-LABEL: @bitreverse_8i16(
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @src16, align 2
; CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> [[TMP1]])
; CHECK-NEXT:    store <8 x i16> [[TMP2]], ptr @dst16, align 2
; CHECK-NEXT:    ret void
;
  %ld0 = load i16, ptr @src16, align 2
  %ld1 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 1), align 2
  %ld2 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 2), align 2
  %ld3 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 3), align 2
  %ld4 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 4), align 2
  %ld5 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 5), align 2
  %ld6 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 6), align 2
  %ld7 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 7), align 2
  %bitreverse0 = call i16 @llvm.bitreverse.i16(i16 %ld0)
  %bitreverse1 = call i16 @llvm.bitreverse.i16(i16 %ld1)
  %bitreverse2 = call i16 @llvm.bitreverse.i16(i16 %ld2)
  %bitreverse3 = call i16 @llvm.bitreverse.i16(i16 %ld3)
  %bitreverse4 = call i16 @llvm.bitreverse.i16(i16 %ld4)
  %bitreverse5 = call i16 @llvm.bitreverse.i16(i16 %ld5)
  %bitreverse6 = call i16 @llvm.bitreverse.i16(i16 %ld6)
  %bitreverse7 = call i16 @llvm.bitreverse.i16(i16 %ld7)
  store i16 %bitreverse0, ptr @dst16, align 2
  store i16 %bitreverse1, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 1), align 2
  store i16 %bitreverse2, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 2), align 2
  store i16 %bitreverse3, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 3), align 2
  store i16 %bitreverse4, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 4), align 2
  store i16 %bitreverse5, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 5), align 2
  store i16 %bitreverse6, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 6), align 2
  store i16 %bitreverse7, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 7), align 2
  ret void
}

define void @bitreverse_16i16() #0 {
; SSE-LABEL: @bitreverse_16i16(
; SSE-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @src16, align 2
; SSE-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> [[TMP1]])
; SSE-NEXT:    store <8 x i16> [[TMP2]], ptr @dst16, align 2
; SSE-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 8), align 2
; SSE-NEXT:    [[TMP4:%.*]] = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> [[TMP3]])
; SSE-NEXT:    store <8 x i16> [[TMP4]], ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 8), align 2
; SSE-NEXT:    ret void
;
; AVX-LABEL: @bitreverse_16i16(
; AVX-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @src16, align 2
; AVX-NEXT:    [[TMP2:%.*]] = call <16 x i16> @llvm.bitreverse.v16i16(<16 x i16> [[TMP1]])
; AVX-NEXT:    store <16 x i16> [[TMP2]], ptr @dst16, align 2
; AVX-NEXT:    ret void
;
; XOP-LABEL: @bitreverse_16i16(
; XOP-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @src16, align 2
; XOP-NEXT:    [[TMP2:%.*]] = call <16 x i16> @llvm.bitreverse.v16i16(<16 x i16> [[TMP1]])
; XOP-NEXT:    store <16 x i16> [[TMP2]], ptr @dst16, align 2
; XOP-NEXT:    ret void
;
  %ld0  = load i16, ptr @src16, align 2
  %ld1  = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64  1), align 2
  %ld2  = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64  2), align 2
  %ld3  = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64  3), align 2
  %ld4  = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64  4), align 2
  %ld5  = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64  5), align 2
  %ld6  = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64  6), align 2
  %ld7  = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64  7), align 2
  %ld8  = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64  8), align 2
  %ld9  = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64  9), align 2
  %ld10 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 10), align 2
  %ld11 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 11), align 2
  %ld12 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 12), align 2
  %ld13 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 13), align 2
  %ld14 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 14), align 2
  %ld15 = load i16, ptr getelementptr inbounds ([16 x i16], ptr @src16, i16 0, i64 15), align 2
  %bitreverse0  = call i16 @llvm.bitreverse.i16(i16 %ld0)
  %bitreverse1  = call i16 @llvm.bitreverse.i16(i16 %ld1)
  %bitreverse2  = call i16 @llvm.bitreverse.i16(i16 %ld2)
  %bitreverse3  = call i16 @llvm.bitreverse.i16(i16 %ld3)
  %bitreverse4  = call i16 @llvm.bitreverse.i16(i16 %ld4)
  %bitreverse5  = call i16 @llvm.bitreverse.i16(i16 %ld5)
  %bitreverse6  = call i16 @llvm.bitreverse.i16(i16 %ld6)
  %bitreverse7  = call i16 @llvm.bitreverse.i16(i16 %ld7)
  %bitreverse8  = call i16 @llvm.bitreverse.i16(i16 %ld8)
  %bitreverse9  = call i16 @llvm.bitreverse.i16(i16 %ld9)
  %bitreverse10 = call i16 @llvm.bitreverse.i16(i16 %ld10)
  %bitreverse11 = call i16 @llvm.bitreverse.i16(i16 %ld11)
  %bitreverse12 = call i16 @llvm.bitreverse.i16(i16 %ld12)
  %bitreverse13 = call i16 @llvm.bitreverse.i16(i16 %ld13)
  %bitreverse14 = call i16 @llvm.bitreverse.i16(i16 %ld14)
  %bitreverse15 = call i16 @llvm.bitreverse.i16(i16 %ld15)
  store i16 %bitreverse0 , ptr @dst16, align 2
  store i16 %bitreverse1 , ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64  1), align 2
  store i16 %bitreverse2 , ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64  2), align 2
  store i16 %bitreverse3 , ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64  3), align 2
  store i16 %bitreverse4 , ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64  4), align 2
  store i16 %bitreverse5 , ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64  5), align 2
  store i16 %bitreverse6 , ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64  6), align 2
  store i16 %bitreverse7 , ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64  7), align 2
  store i16 %bitreverse8 , ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64  8), align 2
  store i16 %bitreverse9 , ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64  9), align 2
  store i16 %bitreverse10, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 10), align 2
  store i16 %bitreverse11, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 11), align 2
  store i16 %bitreverse12, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 12), align 2
  store i16 %bitreverse13, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 13), align 2
  store i16 %bitreverse14, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 14), align 2
  store i16 %bitreverse15, ptr getelementptr inbounds ([16 x i16], ptr @dst16, i16 0, i64 15), align 2
  ret void
}

define void @bitreverse_16i8() #0 {
; CHECK-LABEL: @bitreverse_16i8(
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i8>, ptr @src8, align 1
; CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.bitreverse.v16i8(<16 x i8> [[TMP1]])
; CHECK-NEXT:    store <16 x i8> [[TMP2]], ptr @dst8, align 1
; CHECK-NEXT:    ret void
;
  %ld0  = load i8, ptr @src8, align 1
  %ld1  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  1), align 1
  %ld2  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  2), align 1
  %ld3  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  3), align 1
  %ld4  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  4), align 1
  %ld5  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  5), align 1
  %ld6  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  6), align 1
  %ld7  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  7), align 1
  %ld8  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  8), align 1
  %ld9  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  9), align 1
  %ld10 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 10), align 1
  %ld11 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 11), align 1
  %ld12 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 12), align 1
  %ld13 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 13), align 1
  %ld14 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 14), align 1
  %ld15 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 15), align 1
  %bitreverse0  = call i8 @llvm.bitreverse.i8(i8 %ld0)
  %bitreverse1  = call i8 @llvm.bitreverse.i8(i8 %ld1)
  %bitreverse2  = call i8 @llvm.bitreverse.i8(i8 %ld2)
  %bitreverse3  = call i8 @llvm.bitreverse.i8(i8 %ld3)
  %bitreverse4  = call i8 @llvm.bitreverse.i8(i8 %ld4)
  %bitreverse5  = call i8 @llvm.bitreverse.i8(i8 %ld5)
  %bitreverse6  = call i8 @llvm.bitreverse.i8(i8 %ld6)
  %bitreverse7  = call i8 @llvm.bitreverse.i8(i8 %ld7)
  %bitreverse8  = call i8 @llvm.bitreverse.i8(i8 %ld8)
  %bitreverse9  = call i8 @llvm.bitreverse.i8(i8 %ld9)
  %bitreverse10 = call i8 @llvm.bitreverse.i8(i8 %ld10)
  %bitreverse11 = call i8 @llvm.bitreverse.i8(i8 %ld11)
  %bitreverse12 = call i8 @llvm.bitreverse.i8(i8 %ld12)
  %bitreverse13 = call i8 @llvm.bitreverse.i8(i8 %ld13)
  %bitreverse14 = call i8 @llvm.bitreverse.i8(i8 %ld14)
  %bitreverse15 = call i8 @llvm.bitreverse.i8(i8 %ld15)
  store i8 %bitreverse0 , ptr @dst8, align 1
  store i8 %bitreverse1 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  1), align 1
  store i8 %bitreverse2 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  2), align 1
  store i8 %bitreverse3 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  3), align 1
  store i8 %bitreverse4 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  4), align 1
  store i8 %bitreverse5 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  5), align 1
  store i8 %bitreverse6 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  6), align 1
  store i8 %bitreverse7 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  7), align 1
  store i8 %bitreverse8 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  8), align 1
  store i8 %bitreverse9 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  9), align 1
  store i8 %bitreverse10, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 10), align 1
  store i8 %bitreverse11, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 11), align 1
  store i8 %bitreverse12, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 12), align 1
  store i8 %bitreverse13, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 13), align 1
  store i8 %bitreverse14, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 14), align 1
  store i8 %bitreverse15, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 15), align 1
  ret void
}

define void @bitreverse_32i8() #0 {
; SSE-LABEL: @bitreverse_32i8(
; SSE-NEXT:    [[TMP1:%.*]] = load <16 x i8>, ptr @src8, align 1
; SSE-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.bitreverse.v16i8(<16 x i8> [[TMP1]])
; SSE-NEXT:    store <16 x i8> [[TMP2]], ptr @dst8, align 1
; SSE-NEXT:    [[TMP3:%.*]] = load <16 x i8>, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 16), align 1
; SSE-NEXT:    [[TMP4:%.*]] = call <16 x i8> @llvm.bitreverse.v16i8(<16 x i8> [[TMP3]])
; SSE-NEXT:    store <16 x i8> [[TMP4]], ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 16), align 1
; SSE-NEXT:    ret void
;
; AVX-LABEL: @bitreverse_32i8(
; AVX-NEXT:    [[TMP1:%.*]] = load <32 x i8>, ptr @src8, align 1
; AVX-NEXT:    [[TMP2:%.*]] = call <32 x i8> @llvm.bitreverse.v32i8(<32 x i8> [[TMP1]])
; AVX-NEXT:    store <32 x i8> [[TMP2]], ptr @dst8, align 1
; AVX-NEXT:    ret void
;
; XOP-LABEL: @bitreverse_32i8(
; XOP-NEXT:    [[TMP1:%.*]] = load <32 x i8>, ptr @src8, align 1
; XOP-NEXT:    [[TMP2:%.*]] = call <32 x i8> @llvm.bitreverse.v32i8(<32 x i8> [[TMP1]])
; XOP-NEXT:    store <32 x i8> [[TMP2]], ptr @dst8, align 1
; XOP-NEXT:    ret void
;
  %ld0  = load i8, ptr @src8, align 1
  %ld1  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  1), align 1
  %ld2  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  2), align 1
  %ld3  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  3), align 1
  %ld4  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  4), align 1
  %ld5  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  5), align 1
  %ld6  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  6), align 1
  %ld7  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  7), align 1
  %ld8  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  8), align 1
  %ld9  = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64  9), align 1
  %ld10 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 10), align 1
  %ld11 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 11), align 1
  %ld12 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 12), align 1
  %ld13 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 13), align 1
  %ld14 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 14), align 1
  %ld15 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 15), align 1
  %ld16 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 16), align 1
  %ld17 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 17), align 1
  %ld18 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 18), align 1
  %ld19 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 19), align 1
  %ld20 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 20), align 1
  %ld21 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 21), align 1
  %ld22 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 22), align 1
  %ld23 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 23), align 1
  %ld24 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 24), align 1
  %ld25 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 25), align 1
  %ld26 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 26), align 1
  %ld27 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 27), align 1
  %ld28 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 28), align 1
  %ld29 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 29), align 1
  %ld30 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 30), align 1
  %ld31 = load i8, ptr getelementptr inbounds ([32 x i8], ptr @src8, i8 0, i64 31), align 1
  %bitreverse0  = call i8 @llvm.bitreverse.i8(i8 %ld0)
  %bitreverse1  = call i8 @llvm.bitreverse.i8(i8 %ld1)
  %bitreverse2  = call i8 @llvm.bitreverse.i8(i8 %ld2)
  %bitreverse3  = call i8 @llvm.bitreverse.i8(i8 %ld3)
  %bitreverse4  = call i8 @llvm.bitreverse.i8(i8 %ld4)
  %bitreverse5  = call i8 @llvm.bitreverse.i8(i8 %ld5)
  %bitreverse6  = call i8 @llvm.bitreverse.i8(i8 %ld6)
  %bitreverse7  = call i8 @llvm.bitreverse.i8(i8 %ld7)
  %bitreverse8  = call i8 @llvm.bitreverse.i8(i8 %ld8)
  %bitreverse9  = call i8 @llvm.bitreverse.i8(i8 %ld9)
  %bitreverse10 = call i8 @llvm.bitreverse.i8(i8 %ld10)
  %bitreverse11 = call i8 @llvm.bitreverse.i8(i8 %ld11)
  %bitreverse12 = call i8 @llvm.bitreverse.i8(i8 %ld12)
  %bitreverse13 = call i8 @llvm.bitreverse.i8(i8 %ld13)
  %bitreverse14 = call i8 @llvm.bitreverse.i8(i8 %ld14)
  %bitreverse15 = call i8 @llvm.bitreverse.i8(i8 %ld15)
  %bitreverse16 = call i8 @llvm.bitreverse.i8(i8 %ld16)
  %bitreverse17 = call i8 @llvm.bitreverse.i8(i8 %ld17)
  %bitreverse18 = call i8 @llvm.bitreverse.i8(i8 %ld18)
  %bitreverse19 = call i8 @llvm.bitreverse.i8(i8 %ld19)
  %bitreverse20 = call i8 @llvm.bitreverse.i8(i8 %ld20)
  %bitreverse21 = call i8 @llvm.bitreverse.i8(i8 %ld21)
  %bitreverse22 = call i8 @llvm.bitreverse.i8(i8 %ld22)
  %bitreverse23 = call i8 @llvm.bitreverse.i8(i8 %ld23)
  %bitreverse24 = call i8 @llvm.bitreverse.i8(i8 %ld24)
  %bitreverse25 = call i8 @llvm.bitreverse.i8(i8 %ld25)
  %bitreverse26 = call i8 @llvm.bitreverse.i8(i8 %ld26)
  %bitreverse27 = call i8 @llvm.bitreverse.i8(i8 %ld27)
  %bitreverse28 = call i8 @llvm.bitreverse.i8(i8 %ld28)
  %bitreverse29 = call i8 @llvm.bitreverse.i8(i8 %ld29)
  %bitreverse30 = call i8 @llvm.bitreverse.i8(i8 %ld30)
  %bitreverse31 = call i8 @llvm.bitreverse.i8(i8 %ld31)
  store i8 %bitreverse0 , ptr @dst8, align 1
  store i8 %bitreverse1 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  1), align 1
  store i8 %bitreverse2 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  2), align 1
  store i8 %bitreverse3 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  3), align 1
  store i8 %bitreverse4 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  4), align 1
  store i8 %bitreverse5 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  5), align 1
  store i8 %bitreverse6 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  6), align 1
  store i8 %bitreverse7 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  7), align 1
  store i8 %bitreverse8 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  8), align 1
  store i8 %bitreverse9 , ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64  9), align 1
  store i8 %bitreverse10, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 10), align 1
  store i8 %bitreverse11, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 11), align 1
  store i8 %bitreverse12, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 12), align 1
  store i8 %bitreverse13, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 13), align 1
  store i8 %bitreverse14, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 14), align 1
  store i8 %bitreverse15, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 15), align 1
  store i8 %bitreverse16, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 16), align 1
  store i8 %bitreverse17, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 17), align 1
  store i8 %bitreverse18, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 18), align 1
  store i8 %bitreverse19, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 19), align 1
  store i8 %bitreverse20, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 20), align 1
  store i8 %bitreverse21, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 21), align 1
  store i8 %bitreverse22, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 22), align 1
  store i8 %bitreverse23, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 23), align 1
  store i8 %bitreverse24, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 24), align 1
  store i8 %bitreverse25, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 25), align 1
  store i8 %bitreverse26, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 26), align 1
  store i8 %bitreverse27, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 27), align 1
  store i8 %bitreverse28, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 28), align 1
  store i8 %bitreverse29, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 29), align 1
  store i8 %bitreverse30, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 30), align 1
  store i8 %bitreverse31, ptr getelementptr inbounds ([32 x i8], ptr @dst8, i8 0, i64 31), align 1
  ret void
}

attributes #0 = { nounwind }

