; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

define void @bitcast_v4i8(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    ld1b { z0.h }, p0/z, [x0]
; CHECK-NEXT:    st1b { z0.h }, p0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v4i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldrb w8, [x0]
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #1]
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #2]
; NONEON-NOSVE-NEXT:    ldrb w11, [x0, #3]
; NONEON-NOSVE-NEXT:    strb w11, [x1, #3]
; NONEON-NOSVE-NEXT:    strb w10, [x1, #2]
; NONEON-NOSVE-NEXT:    strb w9, [x1, #1]
; NONEON-NOSVE-NEXT:    strb w8, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <4 x i8>, ptr %a
  %cast = bitcast <4 x i8> %load to <4 x i8>
  store volatile <4 x i8> %cast, ptr %b
  ret void
}

define void @bitcast_v8i8(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    str d0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr d0, [x0]
; NONEON-NOSVE-NEXT:    str d0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <8 x i8>, ptr %a
  %cast = bitcast <8 x i8> %load to <8 x i8>
  store volatile <8 x i8> %cast, ptr %b
  ret void
}

define void @bitcast_v16i8(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <16 x i8>, ptr %a
  %cast = bitcast <16 x i8> %load to <16 x i8>
  store volatile <16 x i8> %cast, ptr %b
  ret void
}

define void @bitcast_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x0, #16]
; CHECK-NEXT:    str q1, [x1, #16]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q1, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x1, #16]
; NONEON-NOSVE-NEXT:    str q0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <32 x i8>, ptr %a
  %cast = bitcast <32 x i8> %load to <32 x i8>
  store volatile <32 x i8> %cast, ptr %b
  ret void
}

define void @bitcast_v2i16(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [x0]
; CHECK-NEXT:    mov z1.s, z0.s[1]
; CHECK-NEXT:    zip1 z0.h, z0.h, z1.h
; CHECK-NEXT:    str s0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v2i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [x0]
; NONEON-NOSVE-NEXT:    ldrh w9, [x0, #2]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp]
; NONEON-NOSVE-NEXT:    ldr d0, [sp]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str w8, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <2 x i16>, ptr %a
  %cast = bitcast <2 x i16> %load to <2 x half>
  store volatile <2 x half> %cast, ptr %b
  ret void
}

define void @bitcast_v4i16(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    str d0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr d0, [x0]
; NONEON-NOSVE-NEXT:    str d0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <4 x i16>, ptr %a
  %cast = bitcast <4 x i16> %load to <4 x half>
  store volatile <4 x half> %cast, ptr %b
  ret void
}

define void @bitcast_v8i16(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <8 x i16>, ptr %a
  %cast = bitcast <8 x i16> %load to <8 x half>
  store volatile <8 x half> %cast, ptr %b
  ret void
}

define void @bitcast_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x0, #16]
; CHECK-NEXT:    str q1, [x1, #16]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q1, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x1, #16]
; NONEON-NOSVE-NEXT:    str q0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <16 x i16>, ptr %a
  %cast = bitcast <16 x i16> %load to <16 x half>
  store volatile <16 x half> %cast, ptr %b
  ret void
}

define void @bitcast_v2i32(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    str d0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr d0, [x0]
; NONEON-NOSVE-NEXT:    str d0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <2 x i32>, ptr %a
  %cast = bitcast <2 x i32> %load to <2 x float>
  store volatile <2 x float> %cast, ptr %b
  ret void
}

define void @bitcast_v4i32(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <4 x i32>, ptr %a
  %cast = bitcast <4 x i32> %load to <4 x float>
  store volatile <4 x float> %cast, ptr %b
  ret void
}

define void @bitcast_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x0, #16]
; CHECK-NEXT:    str q1, [x1, #16]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q1, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x1, #16]
; NONEON-NOSVE-NEXT:    str q0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <8 x i32>, ptr %a
  %cast = bitcast <8 x i32> %load to <8 x float>
  store volatile <8 x float> %cast, ptr %b
  ret void
}

define void @bitcast_v1i64(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    str d0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr d0, [x0]
; NONEON-NOSVE-NEXT:    str d0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <1 x i64>, ptr %a
  %cast = bitcast <1 x i64> %load to <1 x double>
  store volatile <1 x double> %cast, ptr %b
  ret void
}

define void @bitcast_v2i64(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <2 x i64>, ptr %a
  %cast = bitcast <2 x i64> %load to <2 x double>
  store volatile <2 x double> %cast, ptr %b
  ret void
}

define void @bitcast_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x0, #16]
; CHECK-NEXT:    str q1, [x1, #16]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: bitcast_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q1, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x1, #16]
; NONEON-NOSVE-NEXT:    str q0, [x1]
; NONEON-NOSVE-NEXT:    ret
  %load = load volatile <4 x i64>, ptr %a
  %cast = bitcast <4 x i64> %load to <4 x double>
  store volatile <4 x double> %cast, ptr %b
  ret void
}

