; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+f,+d,+zvfhmin,+v -target-abi ilp32d -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK
; RUN: llc -mtriple=riscv64 -mattr=+f,+d,+zvfhmin,+v -target-abi lp64d -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK

; Test that we don't crash when scalar f16 isn't legal. Other configurations
; are tested in vsplats-fp.ll

define <vscale x 8 x half> @vsplat_nxv8f16(half %f) {
; CHECK-LABEL: vsplat_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmv.x.w a0, fa0
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %f, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  ret <vscale x 8 x half> %splat
}
