; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=loongarch64 -mattr=+lsx < %s | FileCheck %s

;; 1. trunc(abs(sub(sext(a),sext(b)))) -> abds(a,b) or abdu(a,b)
;; 2. abs(sub_nsw(x, y)) -> abds(a,b)
;; 3. sub(smax(a,b),smin(a,b)) -> abds(a,b) or abdu(a,b)
;; 4. select(icmp(a,b, slt|ult),sub(a,b),sub(b,a)) -> abds(a,b) or abdu(a,b)
;; 5. sub(select(icmp(a,b),a,b),select(icmp(a,b),b,a)) -> abds(a,b) or abdu(a,b)
;;
;; abds / abdu can be lowered to vabsd.{b/h/w/d} / vabsd.{b/h/w/d}u  instruction

;; trunc(abs(sub(sext(a),sext(b)))) -> abds(a,b)
define <16 x i8> @vabsd_b(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vabsd_b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.b $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a.sext = sext <16 x i8> %a to <16 x i16>
  %b.sext = sext <16 x i8> %b to <16 x i16>
  %sub = sub <16 x i16> %a.sext, %b.sext
  %abs = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %sub, i1 true)
  %trunc = trunc <16 x i16> %abs to <16 x i8>
  ret <16 x i8> %trunc
}

define <8 x i16> @vabsd_h(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vabsd_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.h $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a.sext = sext <8 x i16> %a to <8 x i32>
  %b.sext = sext <8 x i16> %b to <8 x i32>
  %sub = sub <8 x i32> %a.sext, %b.sext
  %abs = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %sub, i1 true)
  %trunc = trunc <8 x i32> %abs to <8 x i16>
  ret <8 x i16> %trunc
}

define <4 x i32> @vabsd_w(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vabsd_w:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.w $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a.sext = sext <4 x i32> %a to <4 x i64>
  %b.sext = sext <4 x i32> %b to <4 x i64>
  %sub = sub <4 x i64> %a.sext, %b.sext
  %abs = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %sub, i1 true)
  %trunc = trunc <4 x i64> %abs to <4 x i32>
  ret <4 x i32> %trunc
}

define <2 x i64> @vabsd_d(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vabsd_d:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.d $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a.sext = sext <2 x i64> %a to <2 x i128>
  %b.sext = sext <2 x i64> %b to <2 x i128>
  %sub = sub <2 x i128> %a.sext, %b.sext
  %abs = call <2 x i128> @llvm.abs.v2i128(<2 x i128> %sub, i1 true)
  %trunc = trunc <2 x i128> %abs to <2 x i64>
  ret <2 x i64> %trunc
}

define <16 x i8> @vabsd_bu(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vabsd_bu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.bu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a.zext = zext <16 x i8> %a to <16 x i16>
  %b.zext = zext <16 x i8> %b to <16 x i16>
  %sub = sub <16 x i16> %a.zext, %b.zext
  %abs = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %sub, i1 true)
  %trunc = trunc <16 x i16> %abs to <16 x i8>
  ret <16 x i8> %trunc
}

define <8 x i16> @vabsd_hu(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vabsd_hu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.hu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a.zext = zext <8 x i16> %a to <8 x i32>
  %b.zext = zext <8 x i16> %b to <8 x i32>
  %sub = sub <8 x i32> %a.zext, %b.zext
  %abs = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %sub, i1 true)
  %trunc = trunc <8 x i32> %abs to <8 x i16>
  ret <8 x i16> %trunc
}

define <4 x i32> @vabsd_wu(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vabsd_wu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.wu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a.zext = zext <4 x i32> %a to <4 x i64>
  %b.zext = zext <4 x i32> %b to <4 x i64>
  %sub = sub <4 x i64> %a.zext, %b.zext
  %abs = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %sub, i1 true)
  %trunc = trunc <4 x i64> %abs to <4 x i32>
  ret <4 x i32> %trunc
}

define <2 x i64> @vabsd_du(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vabsd_du:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.du $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a.zext = zext <2 x i64> %a to <2 x i128>
  %b.zext = zext <2 x i64> %b to <2 x i128>
  %sub = sub <2 x i128> %a.zext, %b.zext
  %abs = call <2 x i128> @llvm.abs.v2i128(<2 x i128> %sub, i1 true)
  %trunc = trunc <2 x i128> %abs to <2 x i64>
  ret <2 x i64> %trunc
}

;; abs(sub_nsw(x, y)) -> abds(a,b)
define <16 x i8> @vabsd_b_nsw(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vabsd_b_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.b $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %sub = sub nsw <16 x i8> %a, %b
  %abs = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %sub, i1 true)
  ret <16 x i8> %abs
}

define <8 x i16> @vabsd_h_nsw(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vabsd_h_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.h $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %sub = sub nsw <8 x i16> %a, %b
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  ret <8 x i16> %abs
}

define <4 x i32> @vabsd_w_nsw(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vabsd_w_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.w $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %sub = sub nsw <4 x i32> %a, %b
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  ret <4 x i32> %abs
}

define <2 x i64> @vabsd_d_nsw(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vabsd_d_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.d $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %sub = sub nsw <2 x i64> %a, %b
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  ret <2 x i64> %abs
}

;; sub(smax(a,b),smin(a,b)) -> abds(a,b)
define <16 x i8> @maxmin_b(<16 x i8> %0, <16 x i8> %1) {
; CHECK-LABEL: maxmin_b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.b $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a = tail call <16 x i8> @llvm.smax.v16i8(<16 x i8> %0, <16 x i8> %1)
  %b = tail call <16 x i8> @llvm.smin.v16i8(<16 x i8> %0, <16 x i8> %1)
  %sub = sub <16 x i8> %a, %b
  ret <16 x i8> %sub
}

define <8 x i16> @maxmin_h(<8 x i16> %0, <8 x i16> %1) {
; CHECK-LABEL: maxmin_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.h $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a = tail call <8 x i16> @llvm.smax.v8i16(<8 x i16> %0, <8 x i16> %1)
  %b = tail call <8 x i16> @llvm.smin.v8i16(<8 x i16> %0, <8 x i16> %1)
  %sub = sub <8 x i16> %a, %b
  ret <8 x i16> %sub
}

define <4 x i32> @maxmin_w(<4 x i32> %0, <4 x i32> %1) {
; CHECK-LABEL: maxmin_w:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.w $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a = tail call <4 x i32> @llvm.smax.v4i32(<4 x i32> %0, <4 x i32> %1)
  %b = tail call <4 x i32> @llvm.smin.v4i32(<4 x i32> %0, <4 x i32> %1)
  %sub = sub <4 x i32> %a, %b
  ret <4 x i32> %sub
}

define <2 x i64> @maxmin_d(<2 x i64> %0, <2 x i64> %1) {
; CHECK-LABEL: maxmin_d:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.d $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a = tail call <2 x i64> @llvm.smax.v2i64(<2 x i64> %0, <2 x i64> %1)
  %b = tail call <2 x i64> @llvm.smin.v2i64(<2 x i64> %0, <2 x i64> %1)
  %sub = sub <2 x i64> %a, %b
  ret <2 x i64> %sub
}

define <16 x i8> @maxmin_bu(<16 x i8> %0, <16 x i8> %1) {
; CHECK-LABEL: maxmin_bu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.bu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a = tail call <16 x i8> @llvm.umax.v16i8(<16 x i8> %0, <16 x i8> %1)
  %b = tail call <16 x i8> @llvm.umin.v16i8(<16 x i8> %0, <16 x i8> %1)
  %sub = sub <16 x i8> %a, %b
  ret <16 x i8> %sub
}

define <8 x i16> @maxmin_hu(<8 x i16> %0, <8 x i16> %1) {
; CHECK-LABEL: maxmin_hu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.hu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a = tail call <8 x i16> @llvm.umax.v8i16(<8 x i16> %0, <8 x i16> %1)
  %b = tail call <8 x i16> @llvm.umin.v8i16(<8 x i16> %0, <8 x i16> %1)
  %sub = sub <8 x i16> %a, %b
  ret <8 x i16> %sub
}

define <4 x i32> @maxmin_wu(<4 x i32> %0, <4 x i32> %1) {
; CHECK-LABEL: maxmin_wu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.wu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a = tail call <4 x i32> @llvm.umax.v4i32(<4 x i32> %0, <4 x i32> %1)
  %b = tail call <4 x i32> @llvm.umin.v4i32(<4 x i32> %0, <4 x i32> %1)
  %sub = sub <4 x i32> %a, %b
  ret <4 x i32> %sub
}

define <2 x i64> @maxmin_du(<2 x i64> %0, <2 x i64> %1) {
; CHECK-LABEL: maxmin_du:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.du $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a = tail call <2 x i64> @llvm.umax.v2i64(<2 x i64> %0, <2 x i64> %1)
  %b = tail call <2 x i64> @llvm.umin.v2i64(<2 x i64> %0, <2 x i64> %1)
  %sub = sub <2 x i64> %a, %b
  ret <2 x i64> %sub
}

define <16 x i8> @maxmin_bu_com1(<16 x i8> %0, <16 x i8> %1) {
; CHECK-LABEL: maxmin_bu_com1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.bu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %a = tail call <16 x i8> @llvm.umax.v16i8(<16 x i8> %0, <16 x i8> %1)
  %b = tail call <16 x i8> @llvm.umin.v16i8(<16 x i8> %1, <16 x i8> %0)
  %sub = sub <16 x i8> %a, %b
  ret <16 x i8> %sub
}

;; select(icmp(a,b, slt),sub(a,b),sub(b,a)) -> abds(a,b)
define <16 x i8> @vabsd_b_cmp(<16 x i8> %a, <16 x i8> %b) nounwind {
; CHECK-LABEL: vabsd_b_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.b $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp slt <16 x i8> %a, %b
  %ab = sub <16 x i8> %a, %b
  %ba = sub <16 x i8> %b, %a
  %sel = select <16 x i1> %cmp, <16 x i8> %ba, <16 x i8> %ab
  ret <16 x i8> %sel
}

define <8 x i16> @vabsd_h_cmp(<8 x i16> %a, <8 x i16> %b) nounwind {
; CHECK-LABEL: vabsd_h_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.h $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp slt <8 x i16> %a, %b
  %ab = sub <8 x i16> %a, %b
  %ba = sub <8 x i16> %b, %a
  %sel = select <8 x i1> %cmp, <8 x i16> %ba, <8 x i16> %ab
  ret <8 x i16> %sel
}

define <4 x i32> @vabsd_w_cmp(<4 x i32> %a, <4 x i32> %b) nounwind {
; CHECK-LABEL: vabsd_w_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.w $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp slt <4 x i32> %a, %b
  %ab = sub <4 x i32> %a, %b
  %ba = sub <4 x i32> %b, %a
  %sel = select <4 x i1> %cmp, <4 x i32> %ba, <4 x i32> %ab
  ret <4 x i32> %sel
}

define <2 x i64> @vabsd_d_cmp(<2 x i64> %a, <2 x i64> %b) nounwind {
; CHECK-LABEL: vabsd_d_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.d $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp slt <2 x i64> %a, %b
  %ab = sub <2 x i64> %a, %b
  %ba = sub <2 x i64> %b, %a
  %sel = select <2 x i1> %cmp, <2 x i64> %ba, <2 x i64> %ab
  ret <2 x i64> %sel
}

define <16 x i8> @vabsd_bu_cmp(<16 x i8> %a, <16 x i8> %b) nounwind {
; CHECK-LABEL: vabsd_bu_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.bu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp ult <16 x i8> %a, %b
  %ab = sub <16 x i8> %a, %b
  %ba = sub <16 x i8> %b, %a
  %sel = select <16 x i1> %cmp, <16 x i8> %ba, <16 x i8> %ab
  ret <16 x i8> %sel
}

define <8 x i16> @vabsd_hu_cmp(<8 x i16> %a, <8 x i16> %b) nounwind {
; CHECK-LABEL: vabsd_hu_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.hu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp ult <8 x i16> %a, %b
  %ab = sub <8 x i16> %a, %b
  %ba = sub <8 x i16> %b, %a
  %sel = select <8 x i1> %cmp, <8 x i16> %ba, <8 x i16> %ab
  ret <8 x i16> %sel
}

define <4 x i32> @vabsd_wu_cmp(<4 x i32> %a, <4 x i32> %b) nounwind {
; CHECK-LABEL: vabsd_wu_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.wu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp ult <4 x i32> %a, %b
  %ab = sub <4 x i32> %a, %b
  %ba = sub <4 x i32> %b, %a
  %sel = select <4 x i1> %cmp, <4 x i32> %ba, <4 x i32> %ab
  ret <4 x i32> %sel
}

define <2 x i64> @vabsd_du_cmp(<2 x i64> %a, <2 x i64> %b) nounwind {
; CHECK-LABEL: vabsd_du_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.du $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp ult <2 x i64> %a, %b
  %ab = sub <2 x i64> %a, %b
  %ba = sub <2 x i64> %b, %a
  %sel = select <2 x i1> %cmp, <2 x i64> %ba, <2 x i64> %ab
  ret <2 x i64> %sel
}

;; sub(select(icmp(a,b, slt),a,b),select(icmp(a,b, slt),b,a)) -> abds(a,b)
define <16 x i8> @vabsd_b_select(<16 x i8> %a, <16 x i8> %b) nounwind {
; CHECK-LABEL: vabsd_b_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.b $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp slt <16 x i8> %a, %b
  %ab = select <16 x i1> %cmp, <16 x i8> %a, <16 x i8> %b
  %ba = select <16 x i1> %cmp, <16 x i8> %b, <16 x i8> %a
  %sub = sub <16 x i8> %ba, %ab
  ret <16 x i8> %sub
}

define <8 x i16> @vabsd_h_select(<8 x i16> %a, <8 x i16> %b) nounwind {
; CHECK-LABEL: vabsd_h_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.h $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp sle <8 x i16> %a, %b
  %ab = select <8 x i1> %cmp, <8 x i16> %a, <8 x i16> %b
  %ba = select <8 x i1> %cmp, <8 x i16> %b, <8 x i16> %a
  %sub = sub <8 x i16> %ba, %ab
  ret <8 x i16> %sub
}

define <4 x i32> @vabsd_w_select(<4 x i32> %a, <4 x i32> %b) nounwind {
; CHECK-LABEL: vabsd_w_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.w $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp sgt <4 x i32> %a, %b
  %ab = select <4 x i1> %cmp, <4 x i32> %a, <4 x i32> %b
  %ba = select <4 x i1> %cmp, <4 x i32> %b, <4 x i32> %a
  %sub = sub <4 x i32> %ab, %ba
  ret <4 x i32> %sub
}

define <2 x i64> @vabsd_d_select(<2 x i64> %a, <2 x i64> %b) nounwind {
; CHECK-LABEL: vabsd_d_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.d $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp sge <2 x i64> %a, %b
  %ab = select <2 x i1> %cmp, <2 x i64> %a, <2 x i64> %b
  %ba = select <2 x i1> %cmp, <2 x i64> %b, <2 x i64> %a
  %sub = sub <2 x i64> %ab, %ba
  ret <2 x i64> %sub
}

define <16 x i8> @vabsd_bu_select(<16 x i8> %a, <16 x i8> %b) nounwind {
; CHECK-LABEL: vabsd_bu_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.bu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp ult <16 x i8> %a, %b
  %ab = select <16 x i1> %cmp, <16 x i8> %a, <16 x i8> %b
  %ba = select <16 x i1> %cmp, <16 x i8> %b, <16 x i8> %a
  %sub = sub <16 x i8> %ba, %ab
  ret <16 x i8> %sub
}

define <8 x i16> @vabsd_hu_select(<8 x i16> %a, <8 x i16> %b) nounwind {
; CHECK-LABEL: vabsd_hu_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.hu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp ule <8 x i16> %a, %b
  %ab = select <8 x i1> %cmp, <8 x i16> %a, <8 x i16> %b
  %ba = select <8 x i1> %cmp, <8 x i16> %b, <8 x i16> %a
  %sub = sub <8 x i16> %ba, %ab
  ret <8 x i16> %sub
}

define <4 x i32> @vabsd_wu_select(<4 x i32> %a, <4 x i32> %b) nounwind {
; CHECK-LABEL: vabsd_wu_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.wu $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp ugt <4 x i32> %a, %b
  %ab = select <4 x i1> %cmp, <4 x i32> %a, <4 x i32> %b
  %ba = select <4 x i1> %cmp, <4 x i32> %b, <4 x i32> %a
  %sub = sub <4 x i32> %ab, %ba
  ret <4 x i32> %sub
}

define <2 x i64> @vabsd_du_select(<2 x i64> %a, <2 x i64> %b) nounwind {
; CHECK-LABEL: vabsd_du_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vabsd.du $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %cmp = icmp uge <2 x i64> %a, %b
  %ab = select <2 x i1> %cmp, <2 x i64> %a, <2 x i64> %b
  %ba = select <2 x i1> %cmp, <2 x i64> %b, <2 x i64> %a
  %sub = sub <2 x i64> %ab, %ba
  ret <2 x i64> %sub
}

declare <16 x i8> @llvm.abs.v16i8(<16 x i8>, i1)

declare <8 x i16> @llvm.abs.v8i16(<8 x i16>, i1)
declare <16 x i16> @llvm.abs.v16i16(<16 x i16>, i1)

declare <4 x i32> @llvm.abs.v4i32(<4 x i32>, i1)
declare <8 x i32> @llvm.abs.v8i32(<8 x i32>, i1)

declare <2 x i64> @llvm.abs.v2i64(<2 x i64>, i1)
declare <4 x i64> @llvm.abs.v4i64(<4 x i64>, i1)

declare <2 x i128> @llvm.abs.v2i128(<2 x i128>, i1)

declare <16 x i8> @llvm.smax.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.smax.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.smax.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.smax.v2i64(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.smin.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.smin.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.smin.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.smin.v2i64(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.umax.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.umax.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.umax.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.umax.v2i64(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.umin.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.umin.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.umin.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.umin.v2i64(<2 x i64>, <2 x i64>)
