/* Name bindings

   Copyright (C) 2006-2007 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

   In other words, you are welcome to use, share and improve this program.
   You are forbidden to forbid anyone else to use, share and improve
   what you give them.   Help stamp out software-hoarding!

   Author:
     Ricardo Fernandez Pascual <ricardof@um.es>
     Andrea C. Ornstein <andrea.ornstein@st.com>

   Contact information at STMicroelectronics:
     Andrea C. Ornstein <andrea.ornstein@st.com>
     Erven Rohou        <erven.rohou@st.com>
*/


#ifndef GCC_CIL_BINDINGS_H

#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "tree.h"
#include "ggc.h"

void cil_bindings_init (void);
void cil_bindings_push_level (void);
tree cil_bindings_pop_level (void);
tree cil_bindings_push_decl (tree decl);
tree cil_bindings_push_decl_local (int local_num, tree decl);
tree cil_bindings_push_decl_arg (int arg_num, tree decl);
tree cil_bindings_get_local (int local_num);
tree cil_bindings_get_arg (int arg_num);
void cil_bindings_push_type_decl (const char *name, tree type_node);
tree cil_bindings_get_decls (void);
void cil_bindings_output_statements (tree statements);
tree cil_bindings_output_statements_and_create_temp (tree expresion);

#endif /* GCC_CIL_BINDINGS_H */
