; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple=riscv32 -mattr=+zfa -global-isel < %s \
; RUN: | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+zfa -global-isel < %s \
; RUN: | FileCheck %s


define float @fceil(float %a) {
; CHECK-LABEL: fceil:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.s fa0, fa0, rup
; CHECK-NEXT:    ret
  %b = call float @llvm.ceil.f32(float %a)
  ret float %b
}

define float @ffloor(float %a) {
; CHECK-LABEL: ffloor:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.s fa0, fa0, rdn
; CHECK-NEXT:    ret
  %b = call float @llvm.floor.f32(float %a)
  ret float %b
}

define float @frint(float %a) {
; CHECK-LABEL: frint:
; CHECK:       # %bb.0:
; CHECK-NEXT:    froundnx.s fa0, fa0
; CHECK-NEXT:    ret
  %b = call float @llvm.rint.f32(float %a)
  ret float %b
}

define float @fnearbyint(float %a) {
; CHECK-LABEL: fnearbyint:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.s fa0, fa0
; CHECK-NEXT:    ret
  %b = call float @llvm.nearbyint.f32(float %a)
  ret float %b
}

define float @fround(float %a) {
; CHECK-LABEL: fround:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.s fa0, fa0, rmm
; CHECK-NEXT:    ret
  %b = call float @llvm.round.f32(float %a)
  ret float %b
}

define float @froundeven(float %a) {
; CHECK-LABEL: froundeven:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.s fa0, fa0, rne
; CHECK-NEXT:    ret
  %b = call float @llvm.roundeven.f32(float %a)
  ret float %b
}

define float @ftrunc(float %a) {
; CHECK-LABEL: ftrunc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.s fa0, fa0, rtz
; CHECK-NEXT:    ret
  %b = call float @llvm.trunc.f32(float %a)
  ret float %b
}

define float @fmaximum(float %a, float %b) {
; CHECK-LABEL: fmaximum:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmaxm.s fa0, fa0, fa1
; CHECK-NEXT:    ret
  %c = call float @llvm.maximum.f32(float %a, float %b)
  ret float %c
}

define float @fminimum(float %a, float %b) {
; CHECK-LABEL: fminimum:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fminm.s fa0, fa0, fa1
; CHECK-NEXT:    ret
  %c = call float @llvm.minimum.f32(float %a, float %b)
  ret float %c
}
