; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-unknown-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64-unknown-linux-gnu -global-isel < %s | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define <8 x i8> @and8xi8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: and8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
	%tmp1 = and <8 x i8> %a, %b;
	ret <8 x i8> %tmp1
}

define <16 x i8> @and16xi8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: and16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = and <16 x i8> %a, %b;
	ret <16 x i8> %tmp1
}


define <8 x i8> @orr8xi8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: orr8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
	%tmp1 = or <8 x i8> %a, %b;
	ret <8 x i8> %tmp1
}

define <16 x i8> @orr16xi8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: orr16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = or <16 x i8> %a, %b;
	ret <16 x i8> %tmp1
}


define <8 x i8> @xor8xi8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: xor8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
	%tmp1 = xor <8 x i8> %a, %b;
	ret <8 x i8> %tmp1
}

define <16 x i8> @xor16xi8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: xor16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = xor <16 x i8> %a, %b;
	ret <16 x i8> %tmp1
}

define <8 x i8> @bsl8xi8_const(<8 x i8> %a, <8 x i8> %b)  {
; CHECK-SD-LABEL: bsl8xi8_const:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi d2, #0x00ffff0000ffff
; CHECK-SD-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bsl8xi8_const:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI6_0
; CHECK-GI-NEXT:    ldr d2, [x8, :lo12:.LCPI6_0]
; CHECK-GI-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i8> %a, < i8 -1, i8 -1, i8 0, i8 0, i8 -1, i8 -1, i8 0, i8 0 >
	%tmp2 = and <8 x i8> %b, < i8 0, i8 0, i8 -1, i8 -1, i8 0, i8 0, i8 -1, i8 -1 >
	%tmp3 = or <8 x i8> %tmp1, %tmp2
	ret <8 x i8> %tmp3
}

define <16 x i8> @bsl16xi8_const(<16 x i8> %a, <16 x i8> %b) {
; CHECK-SD-LABEL: bsl16xi8_const:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi v2.2d, #0x000000ffffffff
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bsl16xi8_const:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI7_0
; CHECK-GI-NEXT:    ldr q2, [x8, :lo12:.LCPI7_0]
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <16 x i8> %a, < i8 -1, i8 -1, i8 -1, i8 -1, i8 0, i8 0, i8 0, i8 0, i8 -1, i8 -1, i8 -1, i8 -1, i8 0, i8 0, i8 0, i8 0 >
	%tmp2 = and <16 x i8> %b, < i8 0, i8 0, i8 0, i8 0, i8 -1, i8 -1, i8 -1, i8 -1, i8 0, i8 0, i8 0, i8 0, i8 -1, i8 -1, i8 -1, i8 -1 >
	%tmp3 = or <16 x i8> %tmp1, %tmp2
	ret <16 x i8> %tmp3
}

define <8 x i8> @orn8xi8(<8 x i8> %a, <8 x i8> %b)  {
; CHECK-LABEL: orn8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orn v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp1 = xor <8 x i8> %b, < i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1 >
  %tmp2 = or <8 x i8> %a, %tmp1
  ret <8 x i8> %tmp2
}

define <16 x i8> @orn16xi8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: orn16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orn v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp1 = xor <16 x i8> %b, < i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1 >
  %tmp2 = or <16 x i8> %a, %tmp1
  ret <16 x i8> %tmp2
}

define <8 x i8> @bic8xi8(<8 x i8> %a, <8 x i8> %b)  {
; CHECK-LABEL: bic8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp1 = xor <8 x i8> %b, < i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1 >
  %tmp2 = and <8 x i8> %a, %tmp1
  ret <8 x i8> %tmp2
}

define <16 x i8> @bic16xi8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: bic16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp1 = xor <16 x i8> %b, < i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1 >
  %tmp2 = and <16 x i8> %a, %tmp1
  ret <16 x i8> %tmp2
}

define <2 x i32> @orrimm2s_lsl0(<2 x i32> %a) {
; CHECK-SD-LABEL: orrimm2s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm2s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0x0000ff000000ff
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i32> %a, < i32 255, i32 255>
	ret <2 x i32> %tmp1
}

define <2 x i32> @orrimm2s_lsl8(<2 x i32> %a) {
; CHECK-SD-LABEL: orrimm2s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm2s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0x00ff000000ff00
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i32> %a, < i32 65280, i32 65280>
	ret <2 x i32> %tmp1
}

define <2 x i32> @orrimm2s_lsl16(<2 x i32> %a) {
; CHECK-SD-LABEL: orrimm2s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm2s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xff000000ff0000
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i32> %a, < i32 16711680, i32 16711680>
	ret <2 x i32> %tmp1
}

define <2 x i32> @orrimm2s_lsl24(<2 x i32> %a) {
; CHECK-SD-LABEL: orrimm2s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm2s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xff000000ff000000
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i32> %a, < i32 4278190080, i32 4278190080>
	ret <2 x i32> %tmp1
}

define <4 x i32> @orrimm4s_lsl0(<4 x i32> %a) {
; CHECK-SD-LABEL: orrimm4s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm4s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0x0000ff000000ff
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i32> %a, < i32 255, i32 255, i32 255, i32 255>
	ret <4 x i32> %tmp1
}

define <4 x i32> @orrimm4s_lsl8(<4 x i32> %a) {
; CHECK-SD-LABEL: orrimm4s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm4s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0x00ff000000ff00
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i32> %a, < i32 65280, i32 65280, i32 65280, i32 65280>
	ret <4 x i32> %tmp1
}

define <4 x i32> @orrimm4s_lsl16(<4 x i32> %a) {
; CHECK-SD-LABEL: orrimm4s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm4s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff000000ff0000
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i32> %a, < i32 16711680, i32 16711680, i32 16711680, i32 16711680>
	ret <4 x i32> %tmp1
}

define <4 x i32> @orrimm4s_lsl24(<4 x i32> %a) {
; CHECK-SD-LABEL: orrimm4s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm4s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff000000ff000000
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i32> %a, < i32 4278190080, i32 4278190080, i32 4278190080, i32 4278190080>
	ret <4 x i32> %tmp1
}

define <4 x i16> @orrimm4h_lsl0(<4 x i16> %a) {
; CHECK-SD-LABEL: orrimm4h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm4h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i16> %a, < i16 255, i16 255, i16 255, i16 255 >
	ret <4 x i16> %tmp1
}

define <4 x i16> @orrimm4h_lsl8(<4 x i16> %a) {
; CHECK-SD-LABEL: orrimm4h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm4h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i16> %a, < i16 65280, i16 65280, i16 65280, i16 65280 >
	ret <4 x i16> %tmp1
}

define <8 x i16> @orrimm8h_lsl0(<8 x i16> %a) {
; CHECK-SD-LABEL: orrimm8h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.8h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm8h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i16> %a, < i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255 >
	ret <8 x i16> %tmp1
}

define <8 x i16> @orrimm8h_lsl8(<8 x i16> %a) {
; CHECK-SD-LABEL: orrimm8h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.8h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm8h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i16> %a, < i16 65280, i16 65280, i16 65280, i16 65280, i16 65280, i16 65280, i16 65280, i16 65280 >
	ret <8 x i16> %tmp1
}

define <2 x i32> @bicimm2s_lsl0(<2 x i32> %a) {
; CHECK-SD-LABEL: bicimm2s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm2s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.2s, #16
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i32> %a, < i32 4294967279, i32 4294967279 >
	ret <2 x i32> %tmp1
}

define <2 x i32> @bicimm2s_lsl8(<2 x i32> %a) {
; CHECK-SD-LABEL: bicimm2s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #16, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm2s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.2s, #16, lsl #8
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i32> %a, < i32 4294963199, i32  4294963199 >
	ret <2 x i32> %tmp1
}

define <2 x i32> @bicimm2s_lsl16(<2 x i32> %a) {
; CHECK-SD-LABEL: bicimm2s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #16, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm2s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.2s, #16, lsl #16
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i32> %a, < i32 4293918719, i32 4293918719 >
	ret <2 x i32> %tmp1
}

define <2 x i32> @bicimm2s_lsl124(<2 x i32> %a) {
; CHECK-SD-LABEL: bicimm2s_lsl124:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #16, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm2s_lsl124:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.2s, #16, lsl #24
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i32> %a, < i32 4026531839, i32  4026531839>
	ret <2 x i32> %tmp1
}

define <4 x i32> @bicimm4s_lsl0(<4 x i32> %a) {
; CHECK-SD-LABEL: bicimm4s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm4s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.4s, #16
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i32> %a, < i32 4294967279, i32 4294967279, i32 4294967279, i32 4294967279 >
	ret <4 x i32> %tmp1
}

define <4 x i32> @bicimm4s_lsl8(<4 x i32> %a) {
; CHECK-SD-LABEL: bicimm4s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #16, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm4s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.4s, #16, lsl #8
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i32> %a, < i32 4294963199, i32  4294963199, i32  4294963199, i32  4294963199 >
	ret <4 x i32> %tmp1
}

define <4 x i32> @bicimm4s_lsl16(<4 x i32> %a) {
; CHECK-SD-LABEL: bicimm4s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #16, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm4s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.4s, #16, lsl #16
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i32> %a, < i32 4293918719, i32 4293918719, i32 4293918719, i32 4293918719 >
	ret <4 x i32> %tmp1
}

define <4 x i32> @bicimm4s_lsl124(<4 x i32> %a) {
; CHECK-SD-LABEL: bicimm4s_lsl124:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #16, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm4s_lsl124:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.4s, #16, lsl #24
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i32> %a, < i32 4026531839, i32  4026531839, i32  4026531839, i32  4026531839>
	ret <4 x i32> %tmp1
}

define <4 x i16> @bicimm4h_lsl0_a(<4 x i16> %a) {
; CHECK-SD-LABEL: bicimm4h_lsl0_a:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4h, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm4h_lsl0_a:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.4h, #16
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i16> %a, < i16 4294967279, i16  4294967279, i16  4294967279, i16  4294967279 >
	ret <4 x i16> %tmp1
}

define <4 x i16> @bicimm4h_lsl0_b(<4 x i16> %a) {
; CHECK-SD-LABEL: bicimm4h_lsl0_b:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm4h_lsl0_b:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i16> %a, < i16 65280, i16  65280, i16  65280, i16 65280 >
	ret <4 x i16> %tmp1
}

define <4 x i16> @bicimm4h_lsl8_a(<4 x i16> %a) {
; CHECK-SD-LABEL: bicimm4h_lsl8_a:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4h, #16, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm4h_lsl8_a:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.4h, #16, lsl #8
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i16> %a, < i16 4294963199, i16  4294963199, i16  4294963199, i16  4294963199>
	ret <4 x i16> %tmp1
}

define <4 x i16> @bicimm4h_lsl8_b(<4 x i16> %a) {
; CHECK-SD-LABEL: bicimm4h_lsl8_b:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm4h_lsl8_b:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i16> %a, < i16 255, i16 255, i16 255, i16 255>
	ret <4 x i16> %tmp1
}

define <8 x i16> @bicimm8h_lsl0_a(<8 x i16> %a) {
; CHECK-SD-LABEL: bicimm8h_lsl0_a:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8h, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm8h_lsl0_a:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.8h, #16
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i16> %a, < i16 4294967279, i16  4294967279, i16  4294967279, i16  4294967279,
   i16  4294967279, i16  4294967279, i16  4294967279, i16  4294967279 >
	ret <8 x i16> %tmp1
}

define <8 x i16> @bicimm8h_lsl0_b(<8 x i16> %a) {
; CHECK-SD-LABEL: bicimm8h_lsl0_b:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm8h_lsl0_b:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i16> %a, < i16 65280, i16  65280, i16  65280, i16 65280, i16 65280, i16  65280, i16  65280, i16 65280 >
	ret <8 x i16> %tmp1
}

define <8 x i16> @bicimm8h_lsl8_a(<8 x i16> %a) {
; CHECK-SD-LABEL: bicimm8h_lsl8_a:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8h, #16, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm8h_lsl8_a:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.8h, #16, lsl #8
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i16> %a, < i16 4294963199, i16  4294963199, i16  4294963199, i16  4294963199,
   i16  4294963199, i16  4294963199, i16  4294963199, i16  4294963199>
	ret <8 x i16> %tmp1
}

define <8 x i16> @bicimm8h_lsl8_b(<8 x i16> %a) {
; CHECK-SD-LABEL: bicimm8h_lsl8_b:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bicimm8h_lsl8_b:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i16> %a, < i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
	ret <8 x i16> %tmp1
}

define <2 x i32> @and2xi32(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: and2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
	%tmp1 = and <2 x i32> %a, %b;
	ret <2 x i32> %tmp1
}

define <4 x i16> @and4xi16(<4 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: and4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
	%tmp1 = and <4 x i16> %a, %b;
	ret <4 x i16> %tmp1
}

define <1 x i64> @and1xi64(<1 x i64> %a, <1 x i64> %b) {
; CHECK-SD-LABEL: and1xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and1xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    fmov x9, d1
; CHECK-GI-NEXT:    and x8, x8, x9
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = and <1 x i64> %a, %b;
	ret <1 x i64> %tmp1
}

define <4 x i32> @and4xi32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: and4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = and <4 x i32> %a, %b;
	ret <4 x i32> %tmp1
}

define <8 x i16> @and8xi16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: and8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = and <8 x i16> %a, %b;
	ret <8 x i16> %tmp1
}

define <2 x i64> @and2xi64(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: and2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = and <2 x i64> %a, %b;
	ret <2 x i64> %tmp1
}

define <2 x i32> @orr2xi32(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: orr2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
	%tmp1 = or <2 x i32> %a, %b;
	ret <2 x i32> %tmp1
}

define <4 x i16> @orr4xi16(<4 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: orr4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
	%tmp1 = or <4 x i16> %a, %b;
	ret <4 x i16> %tmp1
}

define <1 x i64> @orr1xi64(<1 x i64> %a, <1 x i64> %b) {
; CHECK-SD-LABEL: orr1xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr1xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    fmov x9, d1
; CHECK-GI-NEXT:    orr x8, x8, x9
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = or <1 x i64> %a, %b;
	ret <1 x i64> %tmp1
}

define <4 x i32> @orr4xi32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: orr4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = or <4 x i32> %a, %b;
	ret <4 x i32> %tmp1
}

define <8 x i16> @orr8xi16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: orr8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = or <8 x i16> %a, %b;
	ret <8 x i16> %tmp1
}

define <2 x i64> @orr2xi64(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: orr2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = or <2 x i64> %a, %b;
	ret <2 x i64> %tmp1
}

define <2 x i32> @eor2xi32(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: eor2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
	%tmp1 = xor <2 x i32> %a, %b;
	ret <2 x i32> %tmp1
}

define <4 x i16> @eor4xi16(<4 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: eor4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
	%tmp1 = xor <4 x i16> %a, %b;
	ret <4 x i16> %tmp1
}

define <1 x i64> @eor1xi64(<1 x i64> %a, <1 x i64> %b) {
; CHECK-SD-LABEL: eor1xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    eor v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: eor1xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    fmov x9, d1
; CHECK-GI-NEXT:    eor x8, x8, x9
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = xor <1 x i64> %a, %b;
	ret <1 x i64> %tmp1
}

define <4 x i32> @eor4xi32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: eor4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = xor <4 x i32> %a, %b;
	ret <4 x i32> %tmp1
}

define <8 x i16> @eor8xi16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: eor8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = xor <8 x i16> %a, %b;
	ret <8 x i16> %tmp1
}

define <2 x i64> @eor2xi64(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: eor2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
	%tmp1 = xor <2 x i64> %a, %b;
	ret <2 x i64> %tmp1
}


define <2 x i32> @bic2xi32(<2 x i32> %a, <2 x i32> %b)  {
; CHECK-LABEL: bic2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp1 = xor <2 x i32> %b, < i32 -1, i32 -1 >
  %tmp2 = and <2 x i32> %a, %tmp1
  ret <2 x i32> %tmp2
}

define <4 x i16> @bic4xi16(<4 x i16> %a, <4 x i16> %b)  {
; CHECK-LABEL: bic4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp1 = xor <4 x i16> %b, < i16 -1, i16 -1, i16 -1, i16-1 >
  %tmp2 = and <4 x i16> %a, %tmp1
  ret <4 x i16> %tmp2
}

define <1 x i64> @bic1xi64(<1 x i64> %a, <1 x i64> %b)  {
; CHECK-SD-LABEL: bic1xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bic1xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d1
; CHECK-GI-NEXT:    fmov x9, d0
; CHECK-GI-NEXT:    bic x8, x9, x8
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
  %tmp1 = xor <1 x i64> %b, < i64 -1>
  %tmp2 = and <1 x i64> %a, %tmp1
  ret <1 x i64> %tmp2
}

define <4 x i32> @bic4xi32(<4 x i32> %a, <4 x i32> %b)  {
; CHECK-LABEL: bic4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp1 = xor <4 x i32> %b, < i32 -1, i32 -1, i32 -1, i32 -1>
  %tmp2 = and <4 x i32> %a, %tmp1
  ret <4 x i32> %tmp2
}

define <8 x i16> @bic8xi16(<8 x i16> %a, <8 x i16> %b)  {
; CHECK-LABEL: bic8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp1 = xor <8 x i16> %b, < i16 -1, i16 -1, i16 -1, i16-1, i16 -1, i16 -1, i16 -1, i16 -1 >
  %tmp2 = and <8 x i16> %a, %tmp1
  ret <8 x i16> %tmp2
}

define <2 x i64> @bic2xi64(<2 x i64> %a, <2 x i64> %b)  {
; CHECK-LABEL: bic2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp1 = xor <2 x i64> %b, < i64 -1, i64 -1>
  %tmp2 = and <2 x i64> %a, %tmp1
  ret <2 x i64> %tmp2
}

define <2 x i32> @orn2xi32(<2 x i32> %a, <2 x i32> %b)  {
; CHECK-LABEL: orn2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orn v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp1 = xor <2 x i32> %b, < i32 -1, i32 -1 >
  %tmp2 = or <2 x i32> %a, %tmp1
  ret <2 x i32> %tmp2
}

define <4 x i16> @orn4xi16(<4 x i16> %a, <4 x i16> %b)  {
; CHECK-LABEL: orn4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orn v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp1 = xor <4 x i16> %b, < i16 -1, i16 -1, i16 -1, i16-1 >
  %tmp2 = or <4 x i16> %a, %tmp1
  ret <4 x i16> %tmp2
}

define <1 x i64> @orn1xi64(<1 x i64> %a, <1 x i64> %b)  {
; CHECK-SD-LABEL: orn1xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orn v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orn1xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d1
; CHECK-GI-NEXT:    fmov x9, d0
; CHECK-GI-NEXT:    orn x8, x9, x8
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
  %tmp1 = xor <1 x i64> %b, < i64 -1>
  %tmp2 = or <1 x i64> %a, %tmp1
  ret <1 x i64> %tmp2
}

define <4 x i32> @orn4xi32(<4 x i32> %a, <4 x i32> %b)  {
; CHECK-LABEL: orn4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orn v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp1 = xor <4 x i32> %b, < i32 -1, i32 -1, i32 -1, i32 -1>
  %tmp2 = or <4 x i32> %a, %tmp1
  ret <4 x i32> %tmp2
}

define <8 x i16> @orn8xi16(<8 x i16> %a, <8 x i16> %b)  {
; CHECK-LABEL: orn8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orn v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp1 = xor <8 x i16> %b, < i16 -1, i16 -1, i16 -1, i16-1, i16 -1, i16 -1, i16 -1, i16 -1 >
  %tmp2 = or <8 x i16> %a, %tmp1
  ret <8 x i16> %tmp2
}

define <2 x i64> @orn2xi64(<2 x i64> %a, <2 x i64> %b)  {
; CHECK-LABEL: orn2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orn v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp1 = xor <2 x i64> %b, < i64 -1, i64 -1>
  %tmp2 = or <2 x i64> %a, %tmp1
  ret <2 x i64> %tmp2
}

define <2 x i32> @bsl2xi32_const(<2 x i32> %a, <2 x i32> %b)  {
; CHECK-SD-LABEL: bsl2xi32_const:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi d2, #0x000000ffffffff
; CHECK-SD-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bsl2xi32_const:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI70_0
; CHECK-GI-NEXT:    ldr d2, [x8, :lo12:.LCPI70_0]
; CHECK-GI-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i32> %a, < i32 -1, i32 0 >
	%tmp2 = and <2 x i32> %b, < i32 0, i32 -1 >
	%tmp3 = or <2 x i32> %tmp1, %tmp2
	ret <2 x i32> %tmp3
}


define <4 x i16> @bsl4xi16_const(<4 x i16> %a, <4 x i16> %b)  {
; CHECK-SD-LABEL: bsl4xi16_const:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi d2, #0x00ffff0000ffff
; CHECK-SD-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bsl4xi16_const:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI71_0
; CHECK-GI-NEXT:    ldr d2, [x8, :lo12:.LCPI71_0]
; CHECK-GI-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i16> %a, < i16 -1, i16 0, i16 -1,i16 0 >
	%tmp2 = and <4 x i16> %b, < i16 0, i16 -1,i16 0, i16 -1 >
	%tmp3 = or <4 x i16> %tmp1, %tmp2
	ret <4 x i16> %tmp3
}

define <1 x i64> @bsl1xi64_const(<1 x i64> %a, <1 x i64> %b)  {
; CHECK-SD-LABEL: bsl1xi64_const:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi d2, #0xffffffffffffff00
; CHECK-SD-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bsl1xi64_const:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    fmov x9, d1
; CHECK-GI-NEXT:    and x8, x8, #0xffffffffffffff00
; CHECK-GI-NEXT:    and x9, x9, #0xff
; CHECK-GI-NEXT:    orr x8, x8, x9
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = and <1 x i64> %a, < i64 -256 >
	%tmp2 = and <1 x i64> %b, < i64 255 >
	%tmp3 = or <1 x i64> %tmp1, %tmp2
	ret <1 x i64> %tmp3
}

define <4 x i32> @bsl4xi32_const(<4 x i32> %a, <4 x i32> %b)  {
; CHECK-SD-LABEL: bsl4xi32_const:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi v2.2d, #0x000000ffffffff
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bsl4xi32_const:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI73_0
; CHECK-GI-NEXT:    ldr q2, [x8, :lo12:.LCPI73_0]
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i32> %a, < i32 -1, i32 0, i32 -1, i32 0 >
	%tmp2 = and <4 x i32> %b, < i32 0, i32 -1, i32 0, i32 -1 >
	%tmp3 = or <4 x i32> %tmp1, %tmp2
	ret <4 x i32> %tmp3
}

define <8 x i16> @bsl8xi16_const(<8 x i16> %a, <8 x i16> %b)  {
; CHECK-SD-LABEL: bsl8xi16_const:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi v2.2d, #0x000000ffffffff
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bsl8xi16_const:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI74_0
; CHECK-GI-NEXT:    ldr q2, [x8, :lo12:.LCPI74_0]
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i16> %a, < i16 -1, i16 -1, i16 0,i16 0, i16 -1, i16 -1, i16 0,i16 0 >
	%tmp2 = and <8 x i16> %b, < i16 0, i16 0, i16 -1, i16 -1, i16 0, i16 0, i16 -1, i16 -1 >
	%tmp3 = or <8 x i16> %tmp1, %tmp2
	ret <8 x i16> %tmp3
}

define <2 x i64> @bsl2xi64_const(<2 x i64> %a, <2 x i64> %b)  {
; CHECK-LABEL: bsl2xi64_const:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI75_0
; CHECK-NEXT:    ldr q2, [x8, :lo12:.LCPI75_0]
; CHECK-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
	%tmp1 = and <2 x i64> %a, < i64 -1, i64 0 >
	%tmp2 = and <2 x i64> %b, < i64 0, i64 -1 >
	%tmp3 = or <2 x i64> %tmp1, %tmp2
	ret <2 x i64> %tmp3
}


define <8 x i8> @bsl8xi8(<8 x i8> %v1, <8 x i8> %v2, <8 x i8> %v3) {
; CHECK-LABEL: bsl8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bsl v0.8b, v1.8b, v2.8b
; CHECK-NEXT:    ret
  %1 = and <8 x i8> %v1, %v2
  %2 = xor <8 x i8> %v1, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %3 = and <8 x i8> %2, %v3
  %4 = or <8 x i8> %1, %3
  ret <8 x i8> %4
}

define <4 x i16> @bsl4xi16(<4 x i16> %v1, <4 x i16> %v2, <4 x i16> %v3) {
; CHECK-LABEL: bsl4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bsl v0.8b, v1.8b, v2.8b
; CHECK-NEXT:    ret
  %1 = and <4 x i16> %v1, %v2
  %2 = xor <4 x i16> %v1, <i16 -1, i16 -1, i16 -1, i16 -1>
  %3 = and <4 x i16> %2, %v3
  %4 = or <4 x i16> %1, %3
  ret <4 x i16> %4
}

define <2 x i32> @bsl2xi32(<2 x i32> %v1, <2 x i32> %v2, <2 x i32> %v3) {
; CHECK-LABEL: bsl2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bsl v0.8b, v1.8b, v2.8b
; CHECK-NEXT:    ret
  %1 = and <2 x i32> %v1, %v2
  %2 = xor <2 x i32> %v1, <i32 -1, i32 -1>
  %3 = and <2 x i32> %2, %v3
  %4 = or <2 x i32> %1, %3
  ret <2 x i32> %4
}

define <1 x i64> @bsl1xi64(<1 x i64> %v1, <1 x i64> %v2, <1 x i64> %v3) {
; CHECK-SD-LABEL: bsl1xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bsl v0.8b, v1.8b, v2.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bsl1xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    fmov x9, d1
; CHECK-GI-NEXT:    fmov x10, d2
; CHECK-GI-NEXT:    and x9, x8, x9
; CHECK-GI-NEXT:    bic x8, x10, x8
; CHECK-GI-NEXT:    orr x8, x9, x8
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
  %1 = and <1 x i64> %v1, %v2
  %2 = xor <1 x i64> %v1, <i64 -1>
  %3 = and <1 x i64> %2, %v3
  %4 = or <1 x i64> %1, %3
  ret <1 x i64> %4
}

define <16 x i8> @bsl16xi8(<16 x i8> %v1, <16 x i8> %v2, <16 x i8> %v3) {
; CHECK-LABEL: bsl16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bsl v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %1 = and <16 x i8> %v1, %v2
  %2 = xor <16 x i8> %v1, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %3 = and <16 x i8> %2, %v3
  %4 = or <16 x i8> %1, %3
  ret <16 x i8> %4
}

define <8 x i16> @bsl8xi16(<8 x i16> %v1, <8 x i16> %v2, <8 x i16> %v3) {
; CHECK-LABEL: bsl8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bsl v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %1 = and <8 x i16> %v1, %v2
  %2 = xor <8 x i16> %v1, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %3 = and <8 x i16> %2, %v3
  %4 = or <8 x i16> %1, %3
  ret <8 x i16> %4
}

define <4 x i32> @bsl4xi32(<4 x i32> %v1, <4 x i32> %v2, <4 x i32> %v3) {
; CHECK-LABEL: bsl4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bsl v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %1 = and <4 x i32> %v1, %v2
  %2 = xor <4 x i32> %v1, <i32 -1, i32 -1, i32 -1, i32 -1>
  %3 = and <4 x i32> %2, %v3
  %4 = or <4 x i32> %1, %3
  ret <4 x i32> %4
}

define <8 x i8> @vselect_constant_cond_zero_v8i8(<8 x i8> %a) {
; CHECK-SD-LABEL: vselect_constant_cond_zero_v8i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi d1, #0x00000000ff00ff
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_constant_cond_zero_v8i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI83_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI83_0]
; CHECK-GI-NEXT:    shl v1.8b, v1.8b, #7
; CHECK-GI-NEXT:    sshr v1.8b, v1.8b, #7
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %b = select <8 x i1> <i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false>, <8 x i8> %a, <8 x i8> zeroinitializer
  ret <8 x i8> %b
}

define <4 x i16> @vselect_constant_cond_zero_v4i16(<4 x i16> %a) {
; CHECK-SD-LABEL: vselect_constant_cond_zero_v4i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi d1, #0xffff00000000ffff
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_constant_cond_zero_v4i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1 // =0x1
; CHECK-GI-NEXT:    mov w9, #0 // =0x0
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    mov v1.h[1], w9
; CHECK-GI-NEXT:    mov v1.h[2], w9
; CHECK-GI-NEXT:    mov v1.h[3], w8
; CHECK-GI-NEXT:    shl v1.4h, v1.4h, #15
; CHECK-GI-NEXT:    sshr v1.4h, v1.4h, #15
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %b = select <4 x i1> <i1 true, i1 false, i1 false, i1 true>, <4 x i16> %a, <4 x i16> zeroinitializer
  ret <4 x i16> %b
}

define <4 x i32> @vselect_constant_cond_zero_v4i32(<4 x i32> %a) {
; CHECK-SD-LABEL: vselect_constant_cond_zero_v4i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI85_0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI85_0]
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_constant_cond_zero_v4i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1 // =0x1
; CHECK-GI-NEXT:    mov w9, #0 // =0x0
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    mov v1.s[1], w9
; CHECK-GI-NEXT:    mov v1.s[2], w9
; CHECK-GI-NEXT:    mov v1.s[3], w8
; CHECK-GI-NEXT:    shl v1.4s, v1.4s, #31
; CHECK-GI-NEXT:    sshr v1.4s, v1.4s, #31
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
  %b = select <4 x i1> <i1 true, i1 false, i1 false, i1 true>, <4 x i32> %a, <4 x i32> zeroinitializer
  ret <4 x i32> %b
}

define <8 x i8> @vselect_constant_cond_v8i8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-SD-LABEL: vselect_constant_cond_v8i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi d2, #0xffffffffff00ff00
; CHECK-SD-NEXT:    movi d3, #0x00000000ff00ff
; CHECK-SD-NEXT:    and v1.8b, v1.8b, v2.8b
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v3.8b
; CHECK-SD-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_constant_cond_v8i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI86_0
; CHECK-GI-NEXT:    ldr d2, [x8, :lo12:.LCPI86_0]
; CHECK-GI-NEXT:    shl v2.8b, v2.8b, #7
; CHECK-GI-NEXT:    sshr v2.8b, v2.8b, #7
; CHECK-GI-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-GI-NEXT:    ret
  %c = select <8 x i1> <i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false>, <8 x i8> %a, <8 x i8> %b
  ret <8 x i8> %c
}

define <4 x i16> @vselect_constant_cond_v4i16(<4 x i16> %a, <4 x i16> %b) {
; CHECK-SD-LABEL: vselect_constant_cond_v4i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi d2, #0x00ffffffff0000
; CHECK-SD-NEXT:    movi d3, #0xffff00000000ffff
; CHECK-SD-NEXT:    and v1.8b, v1.8b, v2.8b
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v3.8b
; CHECK-SD-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_constant_cond_v4i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1 // =0x1
; CHECK-GI-NEXT:    mov w9, #0 // =0x0
; CHECK-GI-NEXT:    fmov s2, w8
; CHECK-GI-NEXT:    mov v2.h[1], w9
; CHECK-GI-NEXT:    mov v2.h[2], w9
; CHECK-GI-NEXT:    mov v2.h[3], w8
; CHECK-GI-NEXT:    shl v2.4h, v2.4h, #15
; CHECK-GI-NEXT:    sshr v2.4h, v2.4h, #15
; CHECK-GI-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-GI-NEXT:    ret
  %c = select <4 x i1> <i1 true, i1 false, i1 false, i1 true>, <4 x i16> %a, <4 x i16> %b
  ret <4 x i16> %c
}

define <4 x i32> @vselect_constant_cond_v4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-SD-LABEL: vselect_constant_cond_v4i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI88_0
; CHECK-SD-NEXT:    ldr q2, [x8, :lo12:.LCPI88_0]
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_constant_cond_v4i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1 // =0x1
; CHECK-GI-NEXT:    mov w9, #0 // =0x0
; CHECK-GI-NEXT:    fmov s2, w8
; CHECK-GI-NEXT:    mov v2.s[1], w9
; CHECK-GI-NEXT:    mov v2.s[2], w9
; CHECK-GI-NEXT:    mov v2.s[3], w8
; CHECK-GI-NEXT:    shl v2.4s, v2.4s, #31
; CHECK-GI-NEXT:    sshr v2.4s, v2.4s, #31
; CHECK-GI-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    ret
  %c = select <4 x i1> <i1 true, i1 false, i1 false, i1 true>, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %c
}

; CHECK-SD: .byte   0
; CHECK-SD: .byte   8
; CHECK-SD: .byte   2
; CHECK-SD: .byte   9
; CHECK-SD: .byte   4
; CHECK-SD: .byte   5
; CHECK-SD: .byte   6
; CHECK-SD: .byte   7
define <8 x i8> @vselect_equivalent_shuffle_v8i8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-SD-LABEL: vselect_equivalent_shuffle_v8i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    adrp x8, .LCPI89_0
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    ldr d1, [x8, :lo12:.LCPI89_0]
; CHECK-SD-NEXT:    tbl v0.8b, { v0.16b }, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_equivalent_shuffle_v8i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    adrp x8, .LCPI89_0
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI89_0]
; CHECK-GI-NEXT:    tbl v0.16b, { v0.16b }, v1.16b
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
  %c = shufflevector <8 x i8> %a, <8 x i8> %b, <8 x i32> <i32 0, i32 8, i32 2, i32 9, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i8> %c
}

define <8 x i8> @vselect_equivalent_shuffle_v8i8_zero(<8 x i8> %a) {
; CHECK-SD-LABEL: vselect_equivalent_shuffle_v8i8_zero:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi d1, #0xffffffff00ff00ff
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_equivalent_shuffle_v8i8_zero:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    adrp x8, .LCPI90_0
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI90_0]
; CHECK-GI-NEXT:    tbl v0.16b, { v0.16b }, v1.16b
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
  %c = shufflevector <8 x i8> %a, <8 x i8> zeroinitializer, <8 x i32> <i32 0, i32 8, i32 2, i32 9, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i8> %c
}

; CHECK-SD-LABEL: .LCPI91_0:
; CHECK-SD-NEXT: .byte   0
; CHECK-SD-NEXT: .byte   255
; CHECK-SD-NEXT: .byte   2
; CHECK-SD-NEXT: .byte   255
; CHECK-SD-NEXT: .byte   4
; CHECK-SD-NEXT: .byte   5
; CHECK-SD-NEXT: .byte   6
; CHECK-SD-NEXT: .byte   7
define <8 x i8> @vselect_equivalent_shuffle_v8i8_zeroswap(<8 x i8> %a) {
; CHECK-SD-LABEL: vselect_equivalent_shuffle_v8i8_zeroswap:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    adrp x8, .LCPI91_0
; CHECK-SD-NEXT:    mov v0.d[1], v0.d[0]
; CHECK-SD-NEXT:    ldr d1, [x8, :lo12:.LCPI91_0]
; CHECK-SD-NEXT:    tbl v0.8b, { v0.16b }, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_equivalent_shuffle_v8i8_zeroswap:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    adrp x8, .LCPI91_0
; CHECK-GI-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-GI-NEXT:    ldr d0, [x8, :lo12:.LCPI91_0]
; CHECK-GI-NEXT:    tbl v0.16b, { v1.16b }, v0.16b
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
  %c = shufflevector <8 x i8> zeroinitializer, <8 x i8> %a, <8 x i32> <i32 8, i32 0, i32 10, i32 1, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i8> %c
}

; CHECK-SD-LABEL: .LCPI92_0:
; CHECK-SD-NEXT: .byte   0
; CHECK-SD-NEXT: .byte   1
; CHECK-SD-NEXT: .byte   16
; CHECK-SD-NEXT: .byte   17
; CHECK-SD-NEXT: .byte   4
; CHECK-SD-NEXT: .byte   5
; CHECK-SD-NEXT: .byte   18
; CHECK-SD-NEXT: .byte   19
; CHECK-SD-NEXT: .byte   8
; CHECK-SD-NEXT: .byte   9
; CHECK-SD-NEXT: .byte   10
; CHECK-SD-NEXT: .byte   11
; CHECK-SD-NEXT: .byte   12
; CHECK-SD-NEXT: .byte   13
; CHECK-SD-NEXT: .byte   14
; CHECK-SD-NEXT: .byte   15
define <8 x i16> @vselect_equivalent_shuffle_v8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-SD-LABEL: vselect_equivalent_shuffle_v8i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI92_0
; CHECK-SD-NEXT:    // kill: def $q1 killed $q1 killed $q0_q1 def $q0_q1
; CHECK-SD-NEXT:    ldr q2, [x8, :lo12:.LCPI92_0]
; CHECK-SD-NEXT:    // kill: def $q0 killed $q0 killed $q0_q1 def $q0_q1
; CHECK-SD-NEXT:    tbl v0.16b, { v0.16b, v1.16b }, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_equivalent_shuffle_v8i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI92_0
; CHECK-GI-NEXT:    // kill: def $q0 killed $q0 killed $q0_q1 def $q0_q1
; CHECK-GI-NEXT:    ldr q2, [x8, :lo12:.LCPI92_0]
; CHECK-GI-NEXT:    // kill: def $q1 killed $q1 killed $q0_q1 def $q0_q1
; CHECK-GI-NEXT:    tbl v0.16b, { v0.16b, v1.16b }, v2.16b
; CHECK-GI-NEXT:    ret
  %c = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 0, i32 8, i32 2, i32 9, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %c
}

; CHECK-SD-LABEL: .LCPI93_0:
; CHECK-SD-NEXT: .hword 65535 // 0xffff
; CHECK-SD-NEXT: .hword 0 // 0x0
; CHECK-SD-NEXT: .hword 65535 // 0xffff
; CHECK-SD-NEXT: .hword 0 // 0x0
; CHECK-SD-NEXT: .hword 65535 // 0xffff
; CHECK-SD-NEXT: .hword 65535 // 0xffff
; CHECK-SD-NEXT: .hword 65535 // 0xffff
; CHECK-SD-NEXT: .hword 65535 // 0xffff
define <8 x i16> @vselect_equivalent_shuffle_v8i16_zero(<8 x i16> %a) {
; CHECK-SD-LABEL: vselect_equivalent_shuffle_v8i16_zero:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI93_0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI93_0]
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_equivalent_shuffle_v8i16_zero:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $q0 killed $q0 def $q0_q1
; CHECK-GI-NEXT:    adrp x8, .LCPI93_0
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    ldr q2, [x8, :lo12:.LCPI93_0]
; CHECK-GI-NEXT:    tbl v0.16b, { v0.16b, v1.16b }, v2.16b
; CHECK-GI-NEXT:    ret
  %c = shufflevector <8 x i16> %a, <8 x i16> zeroinitializer, <8 x i32> <i32 0, i32 8, i32 2, i32 9, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %c
}

; CHECK-SD: .byte   0
; CHECK-SD: .byte   1
; CHECK-SD: .byte   255
; CHECK-SD: .byte   255
; CHECK-SD: .byte   4
; CHECK-SD: .byte   5
; CHECK-SD: .byte   255
; CHECK-SD: .byte   255
; CHECK-SD: .byte   8
; CHECK-SD: .byte   9
; CHECK-SD: .byte   10
; CHECK-SD: .byte   11
; CHECK-SD: .byte   12
; CHECK-SD: .byte   13
; CHECK-SD: .byte   14
; CHECK-SD: .byte   15
define <8 x i16> @vselect_equivalent_shuffle_v8i16_zeroswap(<8 x i16> %a) {
; CHECK-SD-LABEL: vselect_equivalent_shuffle_v8i16_zeroswap:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI94_0
; CHECK-SD-NEXT:    ldr q1, [x8, :lo12:.LCPI94_0]
; CHECK-SD-NEXT:    tbl v0.16b, { v0.16b }, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_equivalent_shuffle_v8i16_zeroswap:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $q0 killed $q0 def $q31_q0
; CHECK-GI-NEXT:    adrp x8, .LCPI94_0
; CHECK-GI-NEXT:    movi v31.2d, #0000000000000000
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI94_0]
; CHECK-GI-NEXT:    tbl v0.16b, { v31.16b, v0.16b }, v1.16b
; CHECK-GI-NEXT:    ret
  %c = shufflevector <8 x i16> zeroinitializer, <8 x i16> %a, <8 x i32> <i32 8, i32 0, i32 10, i32 1, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i16> %c
}

define <4 x i16> @vselect_equivalent_shuffle_v4i16(<4 x i16> %a, <4 x i16> %b) {
; CHECK-SD-LABEL: vselect_equivalent_shuffle_v4i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NEXT:    mov v0.h[2], v1.h[1]
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_equivalent_shuffle_v4i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    adrp x8, .LCPI95_0
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI95_0]
; CHECK-GI-NEXT:    tbl v0.16b, { v0.16b }, v1.16b
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
  %c = shufflevector <4 x i16> %a, <4 x i16> %b, <4 x i32> <i32 0, i32 4, i32 5, i32 3>
  ret <4 x i16> %c
}

define <4 x i32> @vselect_equivalent_shuffle_v4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-SD-LABEL: vselect_equivalent_shuffle_v4i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-SD-NEXT:    mov v0.s[2], v1.s[1]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_equivalent_shuffle_v4i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI96_0
; CHECK-GI-NEXT:    // kill: def $q0 killed $q0 killed $q0_q1 def $q0_q1
; CHECK-GI-NEXT:    ldr q2, [x8, :lo12:.LCPI96_0]
; CHECK-GI-NEXT:    // kill: def $q1 killed $q1 killed $q0_q1 def $q0_q1
; CHECK-GI-NEXT:    tbl v0.16b, { v0.16b, v1.16b }, v2.16b
; CHECK-GI-NEXT:    ret
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 4, i32 5, i32 3>
  ret <4 x i32> %c
}

define <8 x i8> @vselect_cmp_ne(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c) {
; CHECK-SD-LABEL: vselect_cmp_ne:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmeq v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    bsl v0.8b, v2.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_cmp_ne:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmeq v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    bsl v0.8b, v1.8b, v2.8b
; CHECK-GI-NEXT:    ret
  %cmp = icmp ne <8 x i8> %a, %b
  %d = select <8 x i1> %cmp, <8 x i8> %b, <8 x i8> %c
  ret <8 x i8> %d
}

define <8 x i8> @vselect_cmp_eq(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c) {
; CHECK-LABEL: vselect_cmp_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    bsl v0.8b, v1.8b, v2.8b
; CHECK-NEXT:    ret
  %cmp = icmp eq <8 x i8> %a, %b
  %d = select <8 x i1> %cmp, <8 x i8> %b, <8 x i8> %c
  ret <8 x i8> %d
}

define <8 x i8> @vselect_cmpz_ne(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c) {
; CHECK-SD-LABEL: vselect_cmpz_ne:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmeq v0.8b, v0.8b, #0
; CHECK-SD-NEXT:    bsl v0.8b, v2.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: vselect_cmpz_ne:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmtst v0.8b, v0.8b, v0.8b
; CHECK-GI-NEXT:    bsl v0.8b, v1.8b, v2.8b
; CHECK-GI-NEXT:    ret
  %cmp = icmp ne <8 x i8> %a, zeroinitializer
  %d = select <8 x i1> %cmp, <8 x i8> %b, <8 x i8> %c
  ret <8 x i8> %d
}

define <8 x i8> @vselect_cmpz_eq(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c) {
; CHECK-LABEL: vselect_cmpz_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.8b, v0.8b, #0
; CHECK-NEXT:    bsl v0.8b, v1.8b, v2.8b
; CHECK-NEXT:    ret
  %cmp = icmp eq <8 x i8> %a, zeroinitializer
  %d = select <8 x i1> %cmp, <8 x i8> %b, <8 x i8> %c
  ret <8 x i8> %d
}

define <8 x i8> @vselect_tst(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c) {
; CHECK-LABEL: vselect_tst:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    cmeq v0.8b, v0.8b, #0
; CHECK-NEXT:    bsl v0.8b, v2.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp3 = and <8 x i8> %a, %b
  %tmp4 = icmp eq <8 x i8> %tmp3, zeroinitializer
  %d = select <8 x i1> %tmp4, <8 x i8> %c, <8 x i8> %b
  ret <8 x i8> %d
}

define <8 x i8> @sext_tst(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c) {
; CHECK-LABEL: sext_tst:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmtst v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp3 = and <8 x i8> %a, %b
  %tmp4 = icmp ne <8 x i8> %tmp3, zeroinitializer
  %d = sext <8 x i1> %tmp4 to <8 x i8>
  ret <8 x i8> %d
}

define <2 x i64> @bsl2xi64(<2 x i64> %v1, <2 x i64> %v2, <2 x i64> %v3) {
; CHECK-LABEL: bsl2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bsl v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %1 = and <2 x i64> %v1, %v2
  %2 = xor <2 x i64> %v1, <i64 -1, i64 -1>
  %3 = and <2 x i64> %2, %v3
  %4 = or <2 x i64> %1, %3
  ret <2 x i64> %4
}

define <8 x i8> @orrimm8b_as_orrimm4h_lsl0(<8 x i8> %a) {
; CHECK-SD-LABEL: orrimm8b_as_orrimm4h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm8b_as_orrimm4h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI104_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI104_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %val = or <8 x i8> %a, <i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0>
  ret <8 x i8> %val
}

define <8 x i8> @orrimm8b_as_orimm4h_lsl8(<8 x i8> %a) {
; CHECK-SD-LABEL: orrimm8b_as_orimm4h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orrimm8b_as_orimm4h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI105_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI105_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %val = or <8 x i8> %a, <i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255>
  ret <8 x i8> %val
}

define <16 x i8> @orimm16b_as_orrimm8h_lsl0(<16 x i8> %a) {
; CHECK-SD-LABEL: orimm16b_as_orrimm8h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.8h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orimm16b_as_orrimm8h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI106_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI106_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
  %val = or <16 x i8> %a, <i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0>
  ret <16 x i8> %val
}

define <16 x i8> @orimm16b_as_orrimm8h_lsl8(<16 x i8> %a) {
; CHECK-SD-LABEL: orimm16b_as_orrimm8h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.8h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orimm16b_as_orrimm8h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI107_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI107_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
  %val = or <16 x i8> %a, <i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255>
  ret <16 x i8> %val
}

define <8 x i8> @and8imm2s_lsl0(<8 x i8> %a) {
; CHECK-SD-LABEL: and8imm2s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm2s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI108_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI108_0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i8> %a, < i8 0, i8 255, i8 255, i8 255, i8 0, i8 255, i8 255, i8 255>
	ret <8 x i8> %tmp1
}

define <8 x i8> @and8imm2s_lsl8(<8 x i8> %a) {
; CHECK-SD-LABEL: and8imm2s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm2s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI109_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI109_0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i8> %a, < i8 255, i8 0, i8 255, i8 255, i8 255, i8 0, i8 255, i8 255>
	ret <8 x i8> %tmp1
}

define <8 x i8> @and8imm2s_lsl16(<8 x i8> %a) {
; CHECK-SD-LABEL: and8imm2s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm2s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI110_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI110_0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i8> %a, < i8 255, i8 255, i8 0, i8 255, i8 255, i8 255, i8 0, i8 255>
	ret <8 x i8> %tmp1
}

define <8 x i8> @and8imm2s_lsl24(<8 x i8> %a) {
; CHECK-SD-LABEL: and8imm2s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #254, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm2s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI111_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI111_0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i8> %a, < i8 255, i8 255, i8 255, i8 1, i8 255, i8 255, i8 255, i8 1>
	ret <8 x i8> %tmp1
}

define <4 x i16> @and16imm2s_lsl0(<4 x i16> %a) {
; CHECK-SD-LABEL: and16imm2s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm2s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI112_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI112_0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i16> %a, < i16 65280, i16 65535, i16 65280, i16 65535>
	ret <4 x i16> %tmp1
}

define <4 x i16> @and16imm2s_lsl8(<4 x i16> %a) {
; CHECK-SD-LABEL: and16imm2s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm2s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI113_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI113_0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i16> %a, < i16 255, i16 65535, i16 255, i16 65535>
	ret <4 x i16> %tmp1
}

define <4 x i16> @and16imm2s_lsl16(<4 x i16> %a) {
; CHECK-SD-LABEL: and16imm2s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm2s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI114_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI114_0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i16> %a, < i16 65535, i16 65280, i16 65535, i16 65280>
	ret <4 x i16> %tmp1
}

define <4 x i16> @and16imm2s_lsl24(<4 x i16> %a) {
; CHECK-SD-LABEL: and16imm2s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #254, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm2s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI115_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI115_0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i16> %a, < i16 65535, i16 511, i16 65535, i16 511>
	ret <4 x i16> %tmp1
}


define <1 x i64> @and64imm2s_lsl0(<1 x i64> %a) {
; CHECK-SD-LABEL: and64imm2s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm2s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    and x8, x8, #0xffffff00ffffff00
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = and <1 x i64> %a, < i64 -1095216660736>
	ret <1 x i64> %tmp1
}

define <1 x i64> @and64imm2s_lsl8(<1 x i64> %a) {
; CHECK-SD-LABEL: and64imm2s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm2s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    and x8, x8, #0xffff00ffffff00ff
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = and <1 x i64> %a, < i64 -280375465148161>
	ret <1 x i64> %tmp1
}

define <1 x i64> @and64imm2s_lsl16(<1 x i64> %a) {
; CHECK-SD-LABEL: and64imm2s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm2s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    and x8, x8, #0xff00ffffff00ffff
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = and <1 x i64> %a, < i64 -71776119077928961>
	ret <1 x i64> %tmp1
}

define <1 x i64> @and64imm2s_lsl24(<1 x i64> %a) {
; CHECK-SD-LABEL: and64imm2s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.2s, #254, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm2s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    and x8, x8, #0x1ffffff01ffffff
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = and <1 x i64> %a, < i64 144115183814443007>
	ret <1 x i64> %tmp1
}

define <16 x i8> @and8imm4s_lsl0(<16 x i8> %a) {
; CHECK-SD-LABEL: and8imm4s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm4s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI120_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI120_0]
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <16 x i8> %a, < i8 0, i8 255, i8 255, i8 255, i8 0, i8 255, i8 255, i8 255, i8 0, i8 255, i8 255, i8 255, i8 0, i8 255, i8 255, i8 255>
	ret <16 x i8> %tmp1
}

define <16 x i8> @and8imm4s_lsl8(<16 x i8> %a) {
; CHECK-SD-LABEL: and8imm4s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm4s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI121_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI121_0]
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <16 x i8> %a, < i8 255, i8 0, i8 255, i8 255, i8 255, i8 0, i8 255, i8 255, i8 255, i8 0, i8 255, i8 255, i8 255, i8 0, i8 255, i8 255>
	ret <16 x i8> %tmp1
}

define <16 x i8> @and8imm4s_lsl16(<16 x i8> %a) {
; CHECK-SD-LABEL: and8imm4s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm4s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI122_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI122_0]
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <16 x i8> %a, < i8 255, i8 255, i8 0, i8 255, i8 255, i8 255, i8 0, i8 255, i8 255, i8 255, i8 0, i8 255, i8 255, i8 255, i8 0, i8 255>
	ret <16 x i8> %tmp1
}

define <16 x i8> @and8imm4s_lsl24(<16 x i8> %a) {
; CHECK-SD-LABEL: and8imm4s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #254, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm4s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI123_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI123_0]
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <16 x i8> %a, < i8 255, i8 255, i8 255, i8 1, i8 255, i8 255, i8 255, i8 1, i8 255, i8 255, i8 255, i8 1, i8 255, i8 255, i8 255, i8 1>
	ret <16 x i8> %tmp1
}

define <8 x i16> @and16imm4s_lsl0(<8 x i16> %a) {
; CHECK-SD-LABEL: and16imm4s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm4s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI124_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI124_0]
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i16> %a, < i16 65280, i16 65535, i16 65280, i16 65535, i16 65280, i16 65535, i16 65280, i16 65535>
	ret <8 x i16> %tmp1
}

define <8 x i16> @and16imm4s_lsl8(<8 x i16> %a) {
; CHECK-SD-LABEL: and16imm4s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm4s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI125_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI125_0]
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i16> %a, < i16 255, i16 65535, i16 255, i16 65535, i16 255, i16 65535, i16 255, i16 65535>
	ret <8 x i16> %tmp1
}

define <8 x i16> @and16imm4s_lsl16(<8 x i16> %a) {
; CHECK-SD-LABEL: and16imm4s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm4s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI126_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI126_0]
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i16> %a, < i16 65535, i16 65280, i16 65535, i16 65280, i16 65535, i16 65280, i16 65535, i16 65280>
	ret <8 x i16> %tmp1
}

define <8 x i16> @and16imm4s_lsl24(<8 x i16> %a) {
; CHECK-SD-LABEL: and16imm4s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #254, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm4s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI127_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI127_0]
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i16> %a, < i16 65535, i16 511, i16 65535, i16 511, i16 65535, i16 511, i16 65535, i16 511>
	ret <8 x i16> %tmp1
}

define <2 x i64> @and64imm4s_lsl0(<2 x i64> %a) {
; CHECK-SD-LABEL: and64imm4s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm4s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xffffff00ffffff00
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i64> %a, < i64 -1095216660736, i64 -1095216660736>
	ret <2 x i64> %tmp1
}

define <2 x i64> @and64imm4s_lsl8(<2 x i64> %a) {
; CHECK-SD-LABEL: and64imm4s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm4s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xffff00ffffff00ff
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i64> %a, < i64 -280375465148161, i64 -280375465148161>
	ret <2 x i64> %tmp1
}

define <2 x i64> @and64imm4s_lsl16(<2 x i64> %a) {
; CHECK-SD-LABEL: and64imm4s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm4s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ffffff00ffff
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i64> %a, < i64 -71776119077928961, i64 -71776119077928961>
	ret <2 x i64> %tmp1
}

define <2 x i64> @and64imm4s_lsl24(<2 x i64> %a) {
; CHECK-SD-LABEL: and64imm4s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4s, #254, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm4s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mvni v1.4s, #254, lsl #24
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i64> %a, < i64 144115183814443007, i64 144115183814443007>
	ret <2 x i64> %tmp1
}

define <8 x i8> @and8imm4h_lsl0(<8 x i8> %a) {
; CHECK-SD-LABEL: and8imm4h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm4h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI132_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI132_0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i8> %a, < i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255>
	ret <8 x i8> %tmp1
}

define <8 x i8> @and8imm4h_lsl8(<8 x i8> %a) {
; CHECK-SD-LABEL: and8imm4h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm4h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI133_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI133_0]
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <8 x i8> %a, < i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0>
	ret <8 x i8> %tmp1
}

define <2 x i32> @and16imm4h_lsl0(<2 x i32> %a) {
; CHECK-SD-LABEL: and16imm4h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm4h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i32> %a, < i32 4278255360, i32 4278255360>
	ret <2 x i32> %tmp1
}

define <2 x i32> @and16imm4h_lsl8(<2 x i32> %a) {
; CHECK-SD-LABEL: and16imm4h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm4h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i32> %a, < i32 16711935, i32 16711935>
	ret <2 x i32> %tmp1
}

define <1 x i64> @and64imm4h_lsl0(<1 x i64> %a) {
; CHECK-SD-LABEL: and64imm4h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm4h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    and x8, x8, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = and <1 x i64> %a, < i64 -71777214294589696>
	ret <1 x i64> %tmp1
}

define <1 x i64> @and64imm4h_lsl8(<1 x i64> %a) {
; CHECK-SD-LABEL: and64imm4h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm4h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    and x8, x8, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = and <1 x i64> %a, < i64 71777214294589695>
	ret <1 x i64> %tmp1
}

define <16 x i8> @and8imm8h_lsl0(<16 x i8> %a) {
; CHECK-SD-LABEL: and8imm8h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm8h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI138_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI138_0]
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <16 x i8> %a, < i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255 >
	ret <16 x i8> %tmp1
}

define <16 x i8> @and8imm8h_lsl8(<16 x i8> %a) {
; CHECK-SD-LABEL: and8imm8h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and8imm8h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI139_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI139_0]
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <16 x i8> %a, <i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0 >
	ret <16 x i8> %tmp1
}

define <4 x i32> @and16imm8h_lsl0(<4 x i32> %a) {
; CHECK-SD-LABEL: and16imm8h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm8h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i32> %a, < i32 4278255360, i32 4278255360, i32 4278255360, i32 4278255360>
	ret <4 x i32> %tmp1
}

define <4 x i32> @and16imm8h_lsl8(<4 x i32> %a) {
; CHECK-SD-LABEL: and16imm8h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and16imm8h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <4 x i32> %a, < i32 16711935, i32 16711935, i32 16711935, i32 16711935>
	ret <4 x i32> %tmp1
}

define <2 x i64> @and64imm8h_lsl0(<2 x i64> %a) {
; CHECK-SD-LABEL: and64imm8h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm8h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i64> %a, < i64 -71777214294589696, i64 -71777214294589696>
	ret <2 x i64> %tmp1
}

define <2 x i64> @and64imm8h_lsl8(<2 x i64> %a) {
; CHECK-SD-LABEL: and64imm8h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and64imm8h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = and <2 x i64> %a, < i64 71777214294589695, i64 71777214294589695>
	ret <2 x i64> %tmp1
}

define <8 x i16> @bic_shifted_knownbits(<8 x i16> %v) {
; CHECK-SD-LABEL: bic_shifted_knownbits:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushr v0.8h, v0.8h, #9
; CHECK-SD-NEXT:    bic v0.8h, #126
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bic_shifted_knownbits:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    movi v1.8h, #1
; CHECK-GI-NEXT:    ushr v0.8h, v0.8h, #9
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
entry:
  %vshr_n = lshr <8 x i16> %v, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  %and.i = and <8 x i16> %vshr_n, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  ret <8 x i16> %and.i
}

define <8 x i32> @bic_shifted_knownbits2(<8 x i16> %v) {
; CHECK-SD-LABEL: bic_shifted_knownbits2:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v2.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll2 v1.4s, v0.8h, #0
; CHECK-SD-NEXT:    bic v2.4s, #255, lsl #8
; CHECK-SD-NEXT:    bic v1.4s, #255, lsl #8
; CHECK-SD-NEXT:    mov v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bic_shifted_knownbits2:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    adrp x8, .LCPI145_0
; CHECK-GI-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v2.4s, v0.8h, #0
; CHECK-GI-NEXT:    ldr q3, [x8, :lo12:.LCPI145_0]
; CHECK-GI-NEXT:    and v0.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    and v1.16b, v2.16b, v3.16b
; CHECK-GI-NEXT:    ret
entry:
  %vshr_n = zext <8 x i16> %v to <8 x i32>
  %and.i = and <8 x i32> %vshr_n, <i32 4293918975, i32 4293918975, i32 4293918975, i32 4293918975, i32 4293918975, i32 4293918975, i32 4293918975, i32 4293918975>
  ret <8 x i32> %and.i
}

define <8 x i32> @bic_shifted_knownbits3(<8 x i16> %v) {
; CHECK-SD-LABEL: bic_shifted_knownbits3:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    bic v0.8h, #255, lsl #8
; CHECK-SD-NEXT:    ushll2 v1.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bic_shifted_knownbits3:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    and v1.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ushll v0.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    ret
  %a = and <8 x i16> %v, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %and.i = zext <8 x i16> %a to <8 x i32>
  ret <8 x i32> %and.i
}


define <8 x i32> @bic_shifted_knownbits4(<8 x i32> %v) {
; CHECK-SD-LABEL: bic_shifted_knownbits4:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    shl v1.4s, v1.4s, #8
; CHECK-SD-NEXT:    shl v0.4s, v0.4s, #8
; CHECK-SD-NEXT:    bic v0.4s, #255, lsl #8
; CHECK-SD-NEXT:    bic v1.4s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: bic_shifted_knownbits4:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    movi v2.2d, #0xffff0000ffff0000
; CHECK-GI-NEXT:    shl v0.4s, v0.4s, #8
; CHECK-GI-NEXT:    shl v1.4s, v1.4s, #8
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    and v1.16b, v1.16b, v2.16b
; CHECK-GI-NEXT:    ret
entry:
  %vshr_n = shl <8 x i32> %v, <i32 8, i32 8, i32 8, i32 8, i32 8, i32 8, i32 8, i32 8>
  %and.i = and <8 x i32> %vshr_n, <i32 4294901760, i32 4294901760, i32 4294901760, i32 4294901760, i32 4294901760, i32 4294901760, i32 4294901760, i32 4294901760>
  ret <8 x i32> %and.i
}

define <8 x i8> @orr8imm2s_lsl0(<8 x i8> %a) {
; CHECK-SD-LABEL: orr8imm2s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm2s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI148_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI148_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i8> %a, < i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0>
	ret <8 x i8> %tmp1
}

define <8 x i8> @orr8imm2s_lsl8(<8 x i8> %a) {
; CHECK-SD-LABEL: orr8imm2s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm2s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI149_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI149_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i8> %a, < i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0>
	ret <8 x i8> %tmp1
}

define <8 x i8> @orr8imm2s_lsl16(<8 x i8> %a) {
; CHECK-SD-LABEL: orr8imm2s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm2s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI150_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI150_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i8> %a, < i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0>
	ret <8 x i8> %tmp1
}

define <8 x i8> @orr8imm2s_lsl24(<8 x i8> %a) {
; CHECK-SD-LABEL: orr8imm2s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm2s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI151_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI151_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i8> %a, < i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255>
	ret <8 x i8> %tmp1
}

define <4 x i16> @orr16imm2s_lsl0(<4 x i16> %a) {
; CHECK-SD-LABEL: orr16imm2s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm2s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI152_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI152_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i16> %a, < i16 255, i16 0, i16 255, i16 0>
	ret <4 x i16> %tmp1
}

define <4 x i16> @orr16imm2s_lsl8(<4 x i16> %a) {
; CHECK-SD-LABEL: orr16imm2s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm2s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI153_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI153_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i16> %a, < i16 65280, i16 0, i16 65280, i16 0>
	ret <4 x i16> %tmp1
}

define <4 x i16> @orr16imm2s_lsl16(<4 x i16> %a) {
; CHECK-SD-LABEL: orr16imm2s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm2s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI154_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI154_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i16> %a, < i16 0, i16 255, i16 0, i16 255>
	ret <4 x i16> %tmp1
}

define <4 x i16> @orr16imm2s_lsl24(<4 x i16> %a) {
; CHECK-SD-LABEL: orr16imm2s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm2s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI155_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI155_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i16> %a, < i16 0, i16 65280, i16 0, i16 65280>
	ret <4 x i16> %tmp1
}

define <1 x i64> @orr64imm2s_lsl0(<1 x i64> %a) {
; CHECK-SD-LABEL: orr64imm2s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm2s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    orr x8, x8, #0xff000000ff
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = or <1 x i64> %a, < i64 1095216660735>
	ret <1 x i64> %tmp1
}

define <1 x i64> @orr64imm2s_lsl8(<1 x i64> %a) {
; CHECK-SD-LABEL: orr64imm2s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm2s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    orr x8, x8, #0xff000000ff00
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = or <1 x i64> %a, < i64 280375465148160>
	ret <1 x i64> %tmp1
}

define <1 x i64> @orr64imm2s_lsl16(<1 x i64> %a) {
; CHECK-SD-LABEL: orr64imm2s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm2s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    orr x8, x8, #0xff000000ff0000
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = or <1 x i64> %a, < i64 71776119077928960>
	ret <1 x i64> %tmp1
}

define <1 x i64> @orr64imm2s_lsl24(<1 x i64> %a) {
; CHECK-SD-LABEL: orr64imm2s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.2s, #255, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm2s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    orr x8, x8, #0xff000000ff000000
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = or <1 x i64> %a, < i64 -72057589759737856>
	ret <1 x i64> %tmp1
}

define <16 x i8> @orr8imm4s_lsl0(<16 x i8> %a) {
; CHECK-SD-LABEL: orr8imm4s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm4s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI160_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI160_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <16 x i8> %a, < i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0>
	ret <16 x i8> %tmp1
}

define <16 x i8> @orr8imm4s_lsl8(<16 x i8> %a) {
; CHECK-SD-LABEL: orr8imm4s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm4s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI161_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI161_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <16 x i8> %a, < i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0>
	ret <16 x i8> %tmp1
}

define <16 x i8> @orr8imm4s_lsl16(<16 x i8> %a) {
; CHECK-SD-LABEL: orr8imm4s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm4s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI162_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI162_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <16 x i8> %a, < i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0>
	ret <16 x i8> %tmp1
}

define <16 x i8> @orr8imm4s_lsl24(<16 x i8> %a) {
; CHECK-SD-LABEL: orr8imm4s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm4s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI163_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI163_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <16 x i8> %a, < i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255, i8 0, i8 0, i8 0, i8 255>
	ret <16 x i8> %tmp1
}

define <8 x i16> @orr16imm4s_lsl0(<8 x i16> %a) {
; CHECK-SD-LABEL: orr16imm4s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm4s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI164_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI164_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i16> %a, < i16 255, i16 0, i16 255, i16 0, i16 255, i16 0, i16 255, i16 0>
	ret <8 x i16> %tmp1
}

define <8 x i16> @orr16imm4s_lsl8(<8 x i16> %a) {
; CHECK-SD-LABEL: orr16imm4s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm4s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI165_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI165_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i16> %a, < i16 65280, i16 0, i16 65280, i16 0, i16 65280, i16 0, i16 65280, i16 0>
	ret <8 x i16> %tmp1
}

define <8 x i16> @orr16imm4s_lsl16(<8 x i16> %a) {
; CHECK-SD-LABEL: orr16imm4s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm4s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI166_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI166_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i16> %a, < i16 0, i16 255, i16 0, i16 255, i16 0, i16 255, i16 0, i16 255>
	ret <8 x i16> %tmp1
}

define <8 x i16> @orr16imm4s_lsl24(<8 x i16> %a) {
; CHECK-SD-LABEL: orr16imm4s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm4s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI167_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI167_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i16> %a, < i16 0, i16 65280, i16 0, i16 65280, i16 0, i16 65280, i16 0, i16 65280>
	ret <8 x i16> %tmp1
}

define <2 x i64> @orr64imm4s_lsl0(<2 x i64> %a) {
; CHECK-SD-LABEL: orr64imm4s_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm4s_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0x0000ff000000ff
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i64> %a, < i64 1095216660735, i64 1095216660735>
	ret <2 x i64> %tmp1
}

define <2 x i64> @orr64imm4s_lsl8(<2 x i64> %a) {
; CHECK-SD-LABEL: orr64imm4s_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm4s_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0x00ff000000ff00
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i64> %a, < i64 280375465148160, i64 280375465148160>
	ret <2 x i64> %tmp1
}

define <2 x i64> @orr64imm4s_lsl16(<2 x i64> %a) {
; CHECK-SD-LABEL: orr64imm4s_lsl16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm4s_lsl16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff000000ff0000
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i64> %a, < i64 71776119077928960, i64 71776119077928960>
	ret <2 x i64> %tmp1
}

define <2 x i64> @orr64imm4s_lsl24(<2 x i64> %a) {
; CHECK-SD-LABEL: orr64imm4s_lsl24:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4s, #255, lsl #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm4s_lsl24:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff000000ff000000
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i64> %a, < i64 -72057589759737856, i64 -72057589759737856>
	ret <2 x i64> %tmp1
}

define <8 x i8> @orr8imm4h_lsl0(<8 x i8> %a) {
; CHECK-SD-LABEL: orr8imm4h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm4h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI172_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI172_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i8> %a, < i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0>
	ret <8 x i8> %tmp1
}

define <8 x i8> @orr8imm4h_lsl8(<8 x i8> %a) {
; CHECK-SD-LABEL: orr8imm4h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm4h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI173_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI173_0]
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <8 x i8> %a, < i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255>
	ret <8 x i8> %tmp1
}

define <2 x i32> @orr16imm4h_lsl0(<2 x i32> %a) {
; CHECK-SD-LABEL: orr16imm4h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm4h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i32> %a, < i32 16711935, i32 16711935>
	ret <2 x i32> %tmp1
}

define <2 x i32> @orr16imm4h_lsl8(<2 x i32> %a) {
; CHECK-SD-LABEL: orr16imm4h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm4h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i32> %a, < i32 4278255360, i32 4278255360>
	ret <2 x i32> %tmp1
}

define <1 x i64> @orr64imm4h_lsl0(<1 x i64> %a) {
; CHECK-SD-LABEL: orr64imm4h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm4h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    orr x8, x8, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = or <1 x i64> %a, < i64 71777214294589695>
	ret <1 x i64> %tmp1
}

define <1 x i64> @orr64imm4h_lsl8(<1 x i64> %a) {
; CHECK-SD-LABEL: orr64imm4h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm4h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    orr x8, x8, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    ret
	%tmp1 = or <1 x i64> %a, < i64 -71777214294589696>
	ret <1 x i64> %tmp1
}

define <16 x i8> @orr8imm8h_lsl0(<16 x i8> %a) {
; CHECK-SD-LABEL: orr8imm8h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.8h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm8h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI178_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI178_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <16 x i8> %a, < i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0>
	ret <16 x i8> %tmp1
}

define <16 x i8> @orr8imm8h_lsl8(<16 x i8> %a) {
; CHECK-SD-LABEL: orr8imm8h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.8h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr8imm8h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI179_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI179_0]
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <16 x i8> %a, < i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255, i8 0, i8 255>
	ret <16 x i8> %tmp1
}

define <4 x i32> @orr16imm8h_lsl0(<4 x i32> %a) {
; CHECK-SD-LABEL: orr16imm8h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.8h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm8h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i32> %a, < i32 16711935, i32 16711935, i32 16711935, i32 16711935>
	ret <4 x i32> %tmp1
}

define <4 x i32> @orr16imm8h_lsl8(<4 x i32> %a) {
; CHECK-SD-LABEL: orr16imm8h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.8h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr16imm8h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <4 x i32> %a, < i32 4278255360, i32 4278255360, i32 4278255360, i32 4278255360>
	ret <4 x i32> %tmp1
}

define <2 x i64> @orr64imm8h_lsl0(<2 x i64> %a) {
; CHECK-SD-LABEL: orr64imm8h_lsl0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.8h, #255
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm8h_lsl0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i64> %a, < i64 71777214294589695, i64 71777214294589695>
	ret <2 x i64> %tmp1
}

define <2 x i64> @orr64imm8h_lsl8(<2 x i64> %a) {
; CHECK-SD-LABEL: orr64imm8h_lsl8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    orr v0.8h, #255, lsl #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: orr64imm8h_lsl8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff00
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
	%tmp1 = or <2 x i64> %a, < i64 -71777214294589696, i64 -71777214294589696>
	ret <2 x i64> %tmp1
}

