; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=loop-unroll -verify-loop-lcssa -S < %s | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

@b = external local_unnamed_addr global i32, align 4

declare i1 @unknown(i32) readonly nounwind willreturn

define void @main() local_unnamed_addr #0 {
; CHECK-LABEL: @main(
; CHECK-NEXT:  ph1:
; CHECK-NEXT:    br label [[H1:%.*]]
; CHECK:       h1:
; CHECK-NEXT:    [[D_0:%.*]] = phi i32 [ [[TMP0:%.*]], [[LATCH1:%.*]] ], [ undef, [[PH1:%.*]] ]
; CHECK-NEXT:    br label [[PH2:%.*]]
; CHECK:       ph2:
; CHECK-NEXT:    br label [[H2:%.*]]
; CHECK:       h2:
; CHECK-NEXT:    br label [[H3:%.*]]
; CHECK:       h3:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @unknown(i32 0)
; CHECK-NEXT:    br i1 [[C1]], label [[LATCH3:%.*]], label [[EXIT_LOOPEXIT:%.*]]
; CHECK:       latch3:
; CHECK-NEXT:    [[C2:%.*]] = call i1 @unknown(i32 0)
; CHECK-NEXT:    br i1 [[C2]], label [[EXIT3:%.*]], label [[H3]]
; CHECK:       exit3:
; CHECK-NEXT:    br label [[LATCH2:%.*]]
; CHECK:       latch2:
; CHECK-NEXT:    br label [[H3_1:%.*]]
; CHECK:       h3.1:
; CHECK-NEXT:    [[C1_1:%.*]] = call i1 @unknown(i32 1)
; CHECK-NEXT:    br i1 [[C1_1]], label [[LATCH3_1:%.*]], label [[EXIT_LOOPEXIT1:%.*]]
; CHECK:       latch3.1:
; CHECK-NEXT:    [[C2_1:%.*]] = call i1 @unknown(i32 1)
; CHECK-NEXT:    br i1 [[C2_1]], label [[EXIT3_1:%.*]], label [[H3_1]]
; CHECK:       exit3.1:
; CHECK-NEXT:    br label [[LATCH2_1:%.*]]
; CHECK:       latch2.1:
; CHECK-NEXT:    [[C3:%.*]] = call i1 @unknown(i32 [[D_0]])
; CHECK-NEXT:    br i1 [[C3]], label [[LATCH1]], label [[PH2]]
; CHECK:       latch1:
; CHECK-NEXT:    [[TMP0]] = load i32, ptr @b, align 4
; CHECK-NEXT:    br label [[H1]]
; CHECK:       exit.loopexit:
; CHECK-NEXT:    [[D_0_LCSSA_PH:%.*]] = phi i32 [ [[D_0]], [[H3]] ]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       exit.loopexit1:
; CHECK-NEXT:    [[D_0_LCSSA_PH2:%.*]] = phi i32 [ [[D_0]], [[H3_1]] ]
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[D_0_LCSSA:%.*]] = phi i32 [ [[D_0_LCSSA_PH]], [[EXIT_LOOPEXIT]] ], [ [[D_0_LCSSA_PH2]], [[EXIT_LOOPEXIT1]] ]
; CHECK-NEXT:    ret void
;
ph1:
  br label %h1

h1:
  %d.0 = phi i32 [ %1, %latch1 ], [ undef, %ph1 ]
  br label %ph2

ph2:
  br label %h2

h2:
  %0 = phi i32 [ 0, %ph2 ], [ %inc, %latch2 ]
  br label %h3

h3:
  %c1 = call i1 @unknown(i32 %0)
  br i1 %c1, label %latch3, label %exit

latch3:
  %c2 = call i1 @unknown(i32 %0)
  br i1 %c2, label %exit3, label %h3

exit3:
  br label %latch2

latch2:
  %inc = add nuw nsw i32 %0, 1
  %cmp = icmp slt i32 %inc, 2
  br i1 %cmp, label %h2, label %exit2

exit2:
  %c3 = call i1 @unknown(i32 %d.0)
  br i1 %c3, label %latch1, label %ph2

latch1:                 ; preds = %exit2
  %1 = load i32, ptr @b, align 4
  br label %h1

exit:
  %d.0.lcssa = phi i32 [ %d.0, %h3 ]
  ret void
}
