; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --filter-out-after "^scalar.ph:" --version 5
; RUN: opt -p loop-vectorize -force-vector-width=2 -force-vector-interleave=1 -S %s | FileCheck --check-prefixes=VF2 %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-n32:64-S128-Fn32"
target triple = "arm64-apple-macosx"

; FIXME: Currently the widened load/stores incorrectly use the tbaa metadata
; from the first load/store.
define void @load_store_interleave_group_with_metadata(ptr noalias %data) {
; VF2-LABEL: define void @load_store_interleave_group_with_metadata(
; VF2-SAME: ptr noalias [[DATA:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*:]]
; VF2-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = shl nsw i64 [[INDEX]], 1
; VF2-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP0]]
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP1]], align 8
; VF2-NEXT:    store <2 x i64> [[WIDE_LOAD]], ptr [[TMP1]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 1
; VF2-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[INDEX_NEXT]], 100
; VF2-NEXT:    br i1 [[TMP2]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    br i1 true, [[EXIT:label %.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %mul.2 = shl nsw i64 %iv, 1
  %data.0 = getelementptr inbounds i64, ptr %data, i64 %mul.2
  %l.0 = load i64, ptr %data.0, align 8, !tbaa !2, !range !4
  store i64 %l.0, ptr %data.0, align 8, !tbaa !2
  %add.1 = or disjoint i64 %mul.2, 1
  %data.1 = getelementptr inbounds i64, ptr %data, i64 %add.1
  %l.1 = load i64, ptr %data.1, align 8, !tbaa !3, !range !5
  store i64 %l.1, ptr %data.1, align 8, !tbaa !3
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, 100
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

!0 = !{!"Simple C/C++ TBAA"}
!1 = !{!"omnipotent char", !0, i64 0}
!2 = !{!"A", !1, i64 0}
!3 = !{!"B", !1, i64 0}
!4 = !{ i64 0, i64 2 }
!5 = !{ i64 0, i64 2 }

;.
; VF2: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]], [[META2:![0-9]+]]}
; VF2: [[META1]] = !{!"llvm.loop.isvectorized", i32 1}
; VF2: [[META2]] = !{!"llvm.loop.unroll.runtime.disable"}
;.
; VF4: [[TBAA0]] = !{[[META1:![0-9]+]], [[META1]], i64 0}
; VF4: [[META1]] = !{!"omnipotent char", [[META2:![0-9]+]], i64 0}
; VF4: [[META2]] = !{!"Simple C/C++ TBAA"}
; VF4: [[LOOP3]] = distinct !{[[LOOP3]], [[META4:![0-9]+]], [[META5:![0-9]+]]}
; VF4: [[META4]] = !{!"llvm.loop.isvectorized", i32 1}
; VF4: [[META5]] = !{!"llvm.loop.unroll.runtime.disable"}
;.
