/* valacatchclause.c generated by valac, the Vala compiler
 * generated from valacatchclause.vala, do not modify */

/* valacatchclause.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaCatchClausePrivate {
	gchar* _variable_name;
	gchar* _clabel_name;
	ValaDataType* _data_type;
	ValaBlock* _body;
	ValaLocalVariable* _error_variable;
};


static gpointer vala_catch_clause_parent_class = NULL;

#define VALA_CATCH_CLAUSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CATCH_CLAUSE, ValaCatchClausePrivate))
static void vala_catch_clause_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_catch_clause_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_catch_clause_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_catch_clause_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_catch_clause_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_catch_clause_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_catch_clause_finalize (ValaCodeNode * obj);


/**
 * Creates a new catch
 *
 * @param error_type       error type
 * @param variable_name    error variable name
 * @param body             error handler body
 * @param source_reference reference to source code
 * @return                 newly created catch clause
 */
ValaCatchClause* vala_catch_clause_construct (GType object_type, ValaDataType* error_type, const gchar* variable_name, ValaBlock* body, ValaSourceReference* source_reference) {
	ValaCatchClause* self = NULL;
	ValaDataType* _tmp0_;
	const gchar* _tmp1_;
	ValaBlock* _tmp2_;
	ValaSourceReference* _tmp3_;
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaCatchClause*) vala_code_node_construct (object_type);
	_tmp0_ = error_type;
	vala_catch_clause_set_error_type (self, _tmp0_);
	_tmp1_ = variable_name;
	vala_catch_clause_set_variable_name (self, _tmp1_);
	_tmp2_ = body;
	vala_catch_clause_set_body (self, _tmp2_);
	_tmp3_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp3_);
	return self;
}


ValaCatchClause* vala_catch_clause_new (ValaDataType* error_type, const gchar* variable_name, ValaBlock* body, ValaSourceReference* source_reference) {
	return vala_catch_clause_construct (VALA_TYPE_CATCH_CLAUSE, error_type, variable_name, body, source_reference);
}


static void vala_catch_clause_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCatchClause * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaCatchClause*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_catch_clause (_tmp0_, self);
}


static void vala_catch_clause_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCatchClause * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaBlock* _tmp5_;
	ValaBlock* _tmp6_;
	ValaCodeVisitor* _tmp7_;
	self = (ValaCatchClause*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_catch_clause_get_error_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaCodeVisitor* _tmp4_;
		_tmp2_ = vala_catch_clause_get_error_type (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, _tmp4_);
	}
	_tmp5_ = vala_catch_clause_get_body (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp6_, _tmp7_);
}


static void vala_catch_clause_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaCatchClause * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaCatchClause*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_catch_clause_get_error_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_catch_clause_set_error_type (self, _tmp3_);
	}
}


static gboolean vala_catch_clause_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaCatchClause * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp41_;
	ValaDataType* _tmp42_;
	ValaCodeContext* _tmp43_;
	ValaBlock* _tmp44_;
	ValaBlock* _tmp45_;
	ValaCodeContext* _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	self = (ValaCatchClause*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_catch_clause_get_error_type (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		const gchar* _tmp16_;
		_tmp6_ = vala_catch_clause_get_error_type (self);
		_tmp7_ = _tmp6_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_ERROR_TYPE)) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_catch_clause_get_error_type (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("clause must catch a valid error type, found `%s' instead", _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_error (_tmp9_, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp16_ = self->priv->_variable_name;
		if (_tmp16_ != NULL) {
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			ValaDataType* _tmp20_;
			const gchar* _tmp21_;
			ValaLocalVariable* _tmp22_;
			ValaLocalVariable* _tmp23_;
			ValaBlock* _tmp24_;
			ValaBlock* _tmp25_;
			ValaScope* _tmp26_;
			ValaScope* _tmp27_;
			const gchar* _tmp28_;
			ValaLocalVariable* _tmp29_;
			ValaLocalVariable* _tmp30_;
			ValaBlock* _tmp31_;
			ValaBlock* _tmp32_;
			ValaLocalVariable* _tmp33_;
			ValaLocalVariable* _tmp34_;
			ValaLocalVariable* _tmp35_;
			ValaLocalVariable* _tmp36_;
			_tmp17_ = vala_catch_clause_get_error_type (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_data_type_copy (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = self->priv->_variable_name;
			_tmp22_ = vala_local_variable_new (_tmp20_, _tmp21_, NULL, NULL);
			_tmp23_ = _tmp22_;
			vala_catch_clause_set_error_variable (self, _tmp23_);
			_vala_code_node_unref0 (_tmp23_);
			_vala_code_node_unref0 (_tmp20_);
			_tmp24_ = vala_catch_clause_get_body (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_symbol_get_scope ((ValaSymbol*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = self->priv->_variable_name;
			_tmp29_ = vala_catch_clause_get_error_variable (self);
			_tmp30_ = _tmp29_;
			vala_scope_add (_tmp27_, _tmp28_, (ValaSymbol*) _tmp30_);
			_tmp31_ = vala_catch_clause_get_body (self);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_catch_clause_get_error_variable (self);
			_tmp34_ = _tmp33_;
			vala_block_add_local_variable (_tmp32_, _tmp34_);
			_tmp35_ = vala_catch_clause_get_error_variable (self);
			_tmp36_ = _tmp35_;
			vala_code_node_set_checked ((ValaCodeNode*) _tmp36_, TRUE);
		}
	} else {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaErrorType* _tmp39_;
		ValaErrorType* _tmp40_;
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_error_type_new (NULL, NULL, _tmp38_);
		_tmp40_ = _tmp39_;
		vala_catch_clause_set_error_type (self, (ValaDataType*) _tmp40_);
		_vala_code_node_unref0 (_tmp40_);
	}
	_tmp41_ = vala_catch_clause_get_error_type (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp42_, _tmp43_);
	_tmp44_ = vala_catch_clause_get_body (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp45_, _tmp46_);
	_tmp47_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp48_ = _tmp47_;
	result = !_tmp48_;
	return result;
}


static void vala_catch_clause_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaCatchClause * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	ValaCodeGenerator* _tmp4_;
	self = (ValaCatchClause*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_catch_clause_get_error_variable (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaLocalVariable* _tmp2_;
		ValaLocalVariable* _tmp3_;
		_tmp2_ = vala_catch_clause_get_error_variable (self);
		_tmp3_ = _tmp2_;
		vala_symbol_set_active ((ValaSymbol*) _tmp3_, TRUE);
	}
	_tmp4_ = codegen;
	vala_code_visitor_visit_catch_clause ((ValaCodeVisitor*) _tmp4_, self);
}


static void vala_catch_clause_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaCatchClause * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	self = (ValaCatchClause*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_catch_clause_get_error_variable (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaCollection* _tmp2_;
		ValaLocalVariable* _tmp3_;
		ValaLocalVariable* _tmp4_;
		_tmp2_ = collection;
		_tmp3_ = vala_catch_clause_get_error_variable (self);
		_tmp4_ = _tmp3_;
		vala_collection_add (_tmp2_, (ValaVariable*) _tmp4_);
	}
}


ValaDataType* vala_catch_clause_get_error_type (ValaCatchClause* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_catch_clause_set_error_type (ValaCatchClause* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp1_;
	_tmp2_ = self->priv->_data_type;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_;
		_tmp3_ = self->priv->_data_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


const gchar* vala_catch_clause_get_variable_name (ValaCatchClause* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_variable_name;
	result = _tmp0_;
	return result;
}


void vala_catch_clause_set_variable_name (ValaCatchClause* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_variable_name);
	self->priv->_variable_name = _tmp1_;
}


ValaBlock* vala_catch_clause_get_body (ValaCatchClause* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void vala_catch_clause_set_body (ValaCatchClause* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp1_;
	_tmp2_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaLocalVariable* vala_catch_clause_get_error_variable (ValaCatchClause* self) {
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_variable;
	result = _tmp0_;
	return result;
}


void vala_catch_clause_set_error_variable (ValaCatchClause* self, ValaLocalVariable* value) {
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	ValaLocalVariable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_error_variable);
	self->priv->_error_variable = _tmp1_;
	_tmp2_ = self->priv->_error_variable;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


const gchar* vala_catch_clause_get_clabel_name (ValaCatchClause* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_clabel_name;
	result = _tmp0_;
	return result;
}


void vala_catch_clause_set_clabel_name (ValaCatchClause* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_clabel_name);
	self->priv->_clabel_name = _tmp1_;
}


static void vala_catch_clause_class_init (ValaCatchClauseClass * klass) {
	vala_catch_clause_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_catch_clause_finalize;
	g_type_class_add_private (klass, sizeof (ValaCatchClausePrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_catch_clause_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_catch_clause_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_catch_clause_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_catch_clause_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_catch_clause_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_catch_clause_real_get_defined_variables;
}


static void vala_catch_clause_instance_init (ValaCatchClause * self) {
	self->priv = VALA_CATCH_CLAUSE_GET_PRIVATE (self);
}


static void vala_catch_clause_finalize (ValaCodeNode * obj) {
	ValaCatchClause * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CATCH_CLAUSE, ValaCatchClause);
	_g_free0 (self->priv->_variable_name);
	_g_free0 (self->priv->_clabel_name);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_body);
	_vala_code_node_unref0 (self->priv->_error_variable);
	VALA_CODE_NODE_CLASS (vala_catch_clause_parent_class)->finalize (obj);
}


/**
 * Represents a catch clause in a try statement in the source code.
 */
GType vala_catch_clause_get_type (void) {
	static volatile gsize vala_catch_clause_type_id__volatile = 0;
	if (g_once_init_enter (&vala_catch_clause_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCatchClauseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_catch_clause_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCatchClause), 0, (GInstanceInitFunc) vala_catch_clause_instance_init, NULL };
		GType vala_catch_clause_type_id;
		vala_catch_clause_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaCatchClause", &g_define_type_info, 0);
		g_once_init_leave (&vala_catch_clause_type_id__volatile, vala_catch_clause_type_id);
	}
	return vala_catch_clause_type_id__volatile;
}



