/* valaswitchsection.c generated by valac, the Vala compiler
 * generated from valaswitchsection.vala, do not modify */

/* valaswitchsection.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaSwitchSectionPrivate {
	ValaList* labels;
};


static gpointer vala_switch_section_parent_class = NULL;

#define VALA_SWITCH_SECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionPrivate))
static void vala_switch_section_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_switch_section_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_switch_section_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_switch_section_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_switch_section_finalize (ValaCodeNode * obj);


/**
 * Creates a new switch section.
 *
 * @param source_reference reference to source code
 * @return                 newly created switch section
 */
ValaSwitchSection* vala_switch_section_construct (GType object_type, ValaSourceReference* source_reference) {
	ValaSwitchSection* self = NULL;
	ValaSourceReference* _tmp0_;
	_tmp0_ = source_reference;
	self = (ValaSwitchSection*) vala_block_construct (object_type, _tmp0_);
	return self;
}


ValaSwitchSection* vala_switch_section_new (ValaSourceReference* source_reference) {
	return vala_switch_section_construct (VALA_TYPE_SWITCH_SECTION, source_reference);
}


/**
 * Appends the specified label to the list of switch labels.
 *
 * @param label a switch label
 */
void vala_switch_section_add_label (ValaSwitchSection* self, ValaSwitchLabel* label) {
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValaList* _tmp6_;
	ValaSwitchLabel* _tmp7_;
	ValaSwitchLabel* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->labels;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		ValaSwitchLabel* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp3_ = label;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp3_);
		_tmp5_ = _tmp4_;
		vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp5_);
	}
	_tmp6_ = self->priv->labels;
	_tmp7_ = label;
	vala_collection_add ((ValaCollection*) _tmp6_, _tmp7_);
	_tmp8_ = label;
	vala_switch_label_set_section (_tmp8_, self);
}


/**
 * Returns a copy of the list of switch labels.
 *
 * @return switch label list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_switch_section_get_labels (ValaSwitchSection* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->labels;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


gboolean vala_switch_section_has_default_label (ValaSwitchSection* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _label_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_label_list = _tmp1_;
		_tmp2_ = _label_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_label_size = _tmp4_;
		_label_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaSwitchLabel* _tmp11_;
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			_tmp5_ = _label_index;
			_label_index = _tmp5_ + 1;
			_tmp6_ = _label_index;
			_tmp7_ = _label_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _label_list;
			_tmp9_ = _label_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			label = (ValaSwitchLabel*) _tmp10_;
			_tmp11_ = label;
			_tmp12_ = vala_switch_label_get_expression (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ == NULL) {
				result = TRUE;
				_vala_code_node_unref0 (label);
				_vala_iterable_unref0 (_label_list);
				return result;
			}
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	result = FALSE;
	return result;
}


static void vala_switch_section_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSwitchSection * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_switch_section (_tmp0_, self);
}


static void vala_switch_section_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _label_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_label_list = _tmp1_;
		_tmp2_ = _label_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_label_size = _tmp4_;
		_label_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaSwitchLabel* _tmp11_;
			ValaCodeVisitor* _tmp12_;
			_tmp5_ = _label_index;
			_label_index = _tmp5_ + 1;
			_tmp6_ = _label_index;
			_tmp7_ = _label_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _label_list;
			_tmp9_ = _label_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			label = (ValaSwitchLabel*) _tmp10_;
			_tmp11_ = label;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp13_;
		gint _st_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _st_index = 0;
		_tmp13_ = vala_block_get_statements ((ValaBlock*) self);
		_st_list = _tmp13_;
		_tmp14_ = _st_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_st_size = _tmp16_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaStatement* st = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaStatement* _tmp23_;
			ValaCodeVisitor* _tmp24_;
			_tmp17_ = _st_index;
			_st_index = _tmp17_ + 1;
			_tmp18_ = _st_index;
			_tmp19_ = _st_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _st_list;
			_tmp21_ = _st_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			st = (ValaStatement*) _tmp22_;
			_tmp23_ = st;
			_tmp24_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, _tmp24_);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_switch_section_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaSwitchSection * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCodeContext* _tmp16_;
	ValaSemanticAnalyzer* _tmp17_;
	ValaSemanticAnalyzer* _tmp18_;
	ValaSymbol* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaScope* _tmp21_;
	ValaScope* _tmp22_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp23_;
	ValaSemanticAnalyzer* _tmp24_;
	ValaSemanticAnalyzer* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	ValaSymbol* _tmp28_;
	ValaBlock* old_insert_block = NULL;
	ValaCodeContext* _tmp29_;
	ValaSemanticAnalyzer* _tmp30_;
	ValaSemanticAnalyzer* _tmp31_;
	ValaBlock* _tmp32_;
	ValaBlock* _tmp33_;
	ValaCodeContext* _tmp34_;
	ValaSemanticAnalyzer* _tmp35_;
	ValaSemanticAnalyzer* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaSemanticAnalyzer* _tmp38_;
	ValaSemanticAnalyzer* _tmp39_;
	ValaBlock* _tmp40_;
	ValaCodeContext* _tmp77_;
	ValaSemanticAnalyzer* _tmp78_;
	ValaSemanticAnalyzer* _tmp79_;
	ValaSymbol* _tmp80_;
	ValaCodeContext* _tmp81_;
	ValaSemanticAnalyzer* _tmp82_;
	ValaSemanticAnalyzer* _tmp83_;
	ValaBlock* _tmp84_;
	ValaBlock* _tmp85_;
	gboolean _tmp86_;
	gboolean _tmp87_;
	self = (ValaSwitchSection*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp4_;
		gint _label_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _label_index = 0;
		_tmp4_ = vala_switch_section_get_labels (self);
		_label_list = _tmp4_;
		_tmp5_ = _label_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_label_size = _tmp7_;
		_label_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaSwitchLabel* _tmp14_;
			ValaCodeContext* _tmp15_;
			_tmp8_ = _label_index;
			_label_index = _tmp8_ + 1;
			_tmp9_ = _label_index;
			_tmp10_ = _label_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _label_list;
			_tmp12_ = _label_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			label = (ValaSwitchLabel*) _tmp13_;
			_tmp14_ = label;
			_tmp15_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	_tmp16_ = context;
	_tmp17_ = vala_code_context_get_analyzer (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_semantic_analyzer_get_current_symbol (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_symbol_get_scope (_tmp20_);
	_tmp22_ = _tmp21_;
	vala_symbol_set_owner ((ValaSymbol*) self, _tmp22_);
	_tmp23_ = context;
	_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_semantic_analyzer_get_current_symbol (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _vala_code_node_ref0 (_tmp27_);
	old_symbol = _tmp28_;
	_tmp29_ = context;
	_tmp30_ = vala_code_context_get_analyzer (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_->insert_block;
	_tmp33_ = _vala_code_node_ref0 (_tmp32_);
	old_insert_block = _tmp33_;
	_tmp34_ = context;
	_tmp35_ = vala_code_context_get_analyzer (_tmp34_);
	_tmp36_ = _tmp35_;
	vala_semantic_analyzer_set_current_symbol (_tmp36_, (ValaSymbol*) self);
	_tmp37_ = context;
	_tmp38_ = vala_code_context_get_analyzer (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _vala_code_node_ref0 ((ValaBlock*) self);
	_vala_code_node_unref0 (_tmp39_->insert_block);
	_tmp39_->insert_block = _tmp40_;
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp41_;
		gint _st_size = 0;
		ValaList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _st_index = 0;
		_tmp41_ = vala_block_get_statements ((ValaBlock*) self);
		_st_list = _tmp41_;
		_tmp42_ = _st_list;
		_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_st_size = _tmp44_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			ValaStatement* st = NULL;
			ValaList* _tmp48_;
			gint _tmp49_;
			gpointer _tmp50_;
			ValaStatement* _tmp51_;
			ValaCodeContext* _tmp52_;
			_tmp45_ = _st_index;
			_st_index = _tmp45_ + 1;
			_tmp46_ = _st_index;
			_tmp47_ = _st_size;
			if (!(_tmp46_ < _tmp47_)) {
				break;
			}
			_tmp48_ = _st_list;
			_tmp49_ = _st_index;
			_tmp50_ = vala_list_get (_tmp48_, _tmp49_);
			st = (ValaStatement*) _tmp50_;
			_tmp51_ = st;
			_tmp52_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp51_, _tmp52_);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _local_list = NULL;
		ValaList* _tmp53_;
		gint _local_size = 0;
		ValaList* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		gint _local_index = 0;
		_tmp53_ = vala_block_get_local_variables ((ValaBlock*) self);
		_local_list = _tmp53_;
		_tmp54_ = _local_list;
		_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
		_tmp56_ = _tmp55_;
		_local_size = _tmp56_;
		_local_index = -1;
		while (TRUE) {
			gint _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			ValaLocalVariable* local = NULL;
			ValaList* _tmp60_;
			gint _tmp61_;
			gpointer _tmp62_;
			ValaLocalVariable* _tmp63_;
			_tmp57_ = _local_index;
			_local_index = _tmp57_ + 1;
			_tmp58_ = _local_index;
			_tmp59_ = _local_size;
			if (!(_tmp58_ < _tmp59_)) {
				break;
			}
			_tmp60_ = _local_list;
			_tmp61_ = _local_index;
			_tmp62_ = vala_list_get (_tmp60_, _tmp61_);
			local = (ValaLocalVariable*) _tmp62_;
			_tmp63_ = local;
			vala_symbol_set_active ((ValaSymbol*) _tmp63_, FALSE);
			_vala_code_node_unref0 (local);
		}
		_vala_iterable_unref0 (_local_list);
	}
	{
		ValaList* _stmt_list = NULL;
		ValaList* _tmp64_;
		gint _stmt_size = 0;
		ValaList* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _stmt_index = 0;
		_tmp64_ = vala_block_get_statements ((ValaBlock*) self);
		_stmt_list = _tmp64_;
		_tmp65_ = _stmt_list;
		_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
		_tmp67_ = _tmp66_;
		_stmt_size = _tmp67_;
		_stmt_index = -1;
		while (TRUE) {
			gint _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			ValaStatement* stmt = NULL;
			ValaList* _tmp71_;
			gint _tmp72_;
			gpointer _tmp73_;
			ValaStatement* _tmp74_;
			ValaList* _tmp75_;
			ValaList* _tmp76_;
			_tmp68_ = _stmt_index;
			_stmt_index = _tmp68_ + 1;
			_tmp69_ = _stmt_index;
			_tmp70_ = _stmt_size;
			if (!(_tmp69_ < _tmp70_)) {
				break;
			}
			_tmp71_ = _stmt_list;
			_tmp72_ = _stmt_index;
			_tmp73_ = vala_list_get (_tmp71_, _tmp72_);
			stmt = (ValaStatement*) _tmp73_;
			_tmp74_ = stmt;
			_tmp75_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp74_);
			_tmp76_ = _tmp75_;
			vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp76_);
			_vala_iterable_unref0 (_tmp76_);
			_vala_code_node_unref0 (stmt);
		}
		_vala_iterable_unref0 (_stmt_list);
	}
	_tmp77_ = context;
	_tmp78_ = vala_code_context_get_analyzer (_tmp77_);
	_tmp79_ = _tmp78_;
	_tmp80_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp79_, _tmp80_);
	_tmp81_ = context;
	_tmp82_ = vala_code_context_get_analyzer (_tmp81_);
	_tmp83_ = _tmp82_;
	_tmp84_ = old_insert_block;
	_tmp85_ = _vala_code_node_ref0 (_tmp84_);
	_vala_code_node_unref0 (_tmp83_->insert_block);
	_tmp83_->insert_block = _tmp85_;
	_tmp86_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp87_ = _tmp86_;
	result = !_tmp87_;
	_vala_code_node_unref0 (old_insert_block);
	_vala_code_node_unref0 (old_symbol);
	return result;
}


static void vala_switch_section_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaSwitchSection * self;
	ValaCodeGenerator* _tmp13_;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _label_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_label_list = _tmp1_;
		_tmp2_ = _label_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_label_size = _tmp4_;
		_label_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaSwitchLabel* _tmp11_;
			ValaCodeGenerator* _tmp12_;
			_tmp5_ = _label_index;
			_label_index = _tmp5_ + 1;
			_tmp6_ = _label_index;
			_tmp7_ = _label_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _label_list;
			_tmp9_ = _label_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			label = (ValaSwitchLabel*) _tmp10_;
			_tmp11_ = label;
			_tmp12_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	_tmp13_ = codegen;
	VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->emit ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), _tmp13_);
}


static void vala_switch_section_class_init (ValaSwitchSectionClass * klass) {
	vala_switch_section_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_switch_section_finalize;
	g_type_class_add_private (klass, sizeof (ValaSwitchSectionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_switch_section_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_switch_section_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_switch_section_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_switch_section_real_emit;
}


static void vala_switch_section_instance_init (ValaSwitchSection * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_SWITCH_SECTION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_SWITCH_LABEL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->labels = (ValaList*) _tmp1_;
}


static void vala_switch_section_finalize (ValaCodeNode * obj) {
	ValaSwitchSection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SWITCH_SECTION, ValaSwitchSection);
	_vala_iterable_unref0 (self->priv->labels);
	VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->finalize (obj);
}


/**
 * Represents a switch section in the source code.
 */
GType vala_switch_section_get_type (void) {
	static volatile gsize vala_switch_section_type_id__volatile = 0;
	if (g_once_init_enter (&vala_switch_section_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchSection), 0, (GInstanceInitFunc) vala_switch_section_instance_init, NULL };
		GType vala_switch_section_type_id;
		vala_switch_section_type_id = g_type_register_static (VALA_TYPE_BLOCK, "ValaSwitchSection", &g_define_type_info, 0);
		g_once_init_leave (&vala_switch_section_type_id__volatile, vala_switch_section_type_id);
	}
	return vala_switch_section_type_id__volatile;
}



