/* Various Thresholds of MPFR, not exported.

Copyright 2005, 2006, 2007, 2008, 2009 Free Software Foundation, Inc.

This file is part of the GNU MPFR Library.

The GNU MPFR Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The GNU MPFR Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the GNU MPFR Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
MA 02110-1301, USA. */

#ifndef __MPFR_IMPL_H__
# error "MPFR Internal not included"
#endif

/* note: the different macros used here are those defined by gcc,
   for example with gcc -dM -E -xc /dev/null */

/*****************************
 * Threshold for Pentium 4   *
 *****************************/
#if defined (__pentium4)

#define MPFR_MULHIGH_TAB  \
 -1,0,-1,0,-1,0,0,-1,0,-1,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 40,0,0,48,0,0,0,0,0,0,0,0,0,0,48,44, \
 56,0,56,0,46,0,0,56,56,68,52,54,56,56,54,60, \
 56,56,72,60,64,60,80,71,60,88,79,62,60,64,80,72, \
 95,60,78,80,80,65,80,64,96,80,96,80,66,88,96,66, \
 68,68,96,88,95,95,96,94,94,86,96,94,96,95,96,95, \
 96,96,95,96,95,92,96,92,96,112,111,112,111,112,112,111, \
 108,111,128,112,110,112,112,104,112,112,111,112,111,143,126,112, \
 128,112,128,144,127,127,128,112,128,128,120,124,126,120,110,128, \
 120,128,143,126,128,128,126,128,135,128,128,128,111,112,134,127, \
 134,127,128,111,112,125,126,167,134,185,125,126,127,165,125,128, \
 128,125,144,127,166,129,130,168,144,167,168,126,127,128,129,167, \
 168,167,168,143,166,165,164,167,166,167,168,163,191,184,166,167, \
 168,165,166,166,167,168,166,166,167,168,166,167,168,189,188,189, \
 190,164,192,203,167,168,190,175,192,188,190,187,188,192,167,191, \
 188,189,190,191,239,192,168,186,187,188,189,190,191,192,168,165, \
 233,189,166,239,192,167,191,191,190,191,191,189,186,191,188,166, \
 282,191,192,167,190,191,188,191,190,189,192,191,192,188,189,188, \
 240,190,191,192,185,189,189,186,235,192,188,238,191,191,240,232, \
 189,187,191,189,287,287,189,191,191,281,284,192,283,283,190,285, \
 286,287,288,288,284,285,287,282,285,284,201,239,283,281,282,192, \
 284,285,286,287,288,288,240,282,239,284,285,286,287,288,288,284, \
 334,286,335,284,284,334,287,284,285,283,288,281,325,287,280,335, \
 334,335,336,285,286,288,335,331,331,333,334,335,335,336,334,379, \
 335,336,334,287,336,280,329,283,282,334,286,334,335,335,336,281, \
 285,286,334,286,286,334,334,287,334,335,336,336,330,335,332,329, \
 334,287,334,334,332,335,332,331,334,332,332,335,336,332,334,334, \
 334,336,336,336,331,328,330,334,333,334,334,334,334,335,336,336, \
 333,334,329,334,334,332,331,335,333,333,335,336,336,329,332,333, \
 334,335,336,335,334,332,376,334,335,336,380,335,333,334,379,331, \
 335,332,383,376,336,336,379,334,383,335,336,384,376,376,379,378, \
 334,335,378,378,334,380,384,331,376,376,376,377,380,377,381,377, \
 376,376,380,336,379,380,384,379,377,384,377,378,376,376,381,378, \
 377,384,379,378,384,334,379,384,381,378,381,377,378,379,380,381, \
 378,383,380,381,376,383,384,372,376,377,378,379,377,381,379,378, \
 381,378,383,384,378,376,377,381,376,383,383,379,380,381,382,376, \
 384,376,376,336,381,503,380,376,376,377,378,377,380,376,377,379, \
 384,376,378,500,380,384,383,502,380,381,382,379,502,496,496,381, \
 382,499,497,500,501,496,382,498,498,496,381,496,499,497,379,500, \
 497,498,498,500,498,502,496,495,502,496,497,498,499,500,498,502, \
 503,496,493,498,495,496,496,499,497,504,488,496,498,503,498,496, \
 502,495,496,496,501,496,496,497,498,503,500,501,497,497,498,499, \
 496,497,502,499,500,494,497,503,501,502,496,497,498,499,568,496, \
 496,496,496,576,498,499,502,496,502,570,496,497,504,499,568,502, \
 496,497,570,500,500,575,504,500,576,570,569,502,573,568,569,502, \
 572,568,569,570,504,576,575,503,502,503,568,569,568,501,570,573, \
 502,570,576,573,568,575,576,500,568,502,570,575,569,569,569,568, \
 572,570,568,572,568,504,569,573,571,570,568,572,572,573,570,568, \
 568,568,568,563,570,571,568,563,568,569,568,570,568,569,568,575, \
 576,569,568,568,570,570,570,571,568,569,562,575,570,571,569,569, \
 568,569,570,569,570,573,568,564,571,568,568,568,569,570,572,572, \
 568,574,575,576,567,569,569,570,570,572,573,570,575,576,570,568, \
 568,573,568,573,576,575,568,568,569,568,572,569,568,568,568,569, \
 564,569,576,567,568,562,568,571,572,570,576,568,569,570,568,572, \
 563,574,568,570,568,568,570,570,571,569,568,569,570,570,572,563, \
 842,570,568,572,569,574,569,575,576,501,568,503,568,568,568,819, \
 568,568,574,563,568,563,562,564,564,569,574,568,568,568,570,572, \
 569,568,568,575,576,894,568,839,525,576,568,568,569,573,568,568, \
 560,791,793,719,945,563,564,719,562,568,568,570,570,562,568,569, \
 720,564,573,561,560,575,568,563,568,565,568,568,856,570,570,719, \
 816,573,566,575,568,569,568,855,572,573,568,860,857,568,856,867 \
  
#define MPFR_MUL_THRESHOLD 17
#define MPFR_EXP_2_THRESHOLD 691
#define MPFR_EXP_THRESHOLD 23744

/****************************
 * Threshold for Core 2     *
 ****************************/
#elif defined (HAVE_HOST_CORE2) && !defined (__i386) /* 64-bit Core 2 */

#define MPFR_MULHIGH_TAB  \
 -1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,32,32,34,34,0,32, \
 0,0,0,34,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,64,63,63,64,64,63,63,64,64,63,63,64,64, \
 63,63,64,64,63,63,64,64,63,67,64,64,63,63,64,64, \
 67,63,64,68,67,63,64,64,65,67,64,64,63,67,68,72, \
 68,68,69,72,67,76,68,68,84,84,88,79,80,80,105,105, \
 88,88,86,80,105,105,88,88,104,92,105,105,109,106,110,110, \
 105,105,109,103,110,110,105,105,109,106,110,107,105,105,106,109, \
 110,110,105,105,127,109,110,110,126,117,115,124,128,122,129,105, \
 129,105,122,126,127,135,132,132,105,105,110,110,111,107,108,108, \
 105,105,110,110,111,111,116,120,189,189,186,122,183,187,188,188, \
 185,185,186,186,183,183,188,188,189,185,186,186,183,183,188,184, \
 185,189,182,182,183,187,188,188,189,189,186,186,191,187,188,188, \
 189,189,200,200,186,201,187,187,188,188,189,189,200,185,186,201, \
 182,187,188,188,189,189,185,185,186,186,187,187,188,188,189,189, \
 185,185,201,201,187,187,188,188,189,189,195,200,201,186,187,187, \
 188,188,189,189,200,200,196,196,192,187,198,198,199,189,190,190, \
 191,203,192,192,199,199,188,212,201,201,202,202,191,185,186,186, \
 187,199,200,200,225,201,196,196,203,197,198,198,199,199,224,200, \
 201,225,196,232,257,191,192,258,259,259,260,248,261,261,256,256, \
 257,257,204,204,259,259,260,260,261,261,256,256,257,263,228,240, \
 256,270,257,257,272,258,224,273,225,267,240,240,311,311,249,284, \
 285,257,258,258,315,315,239,253,310,261,311,311,312,312,271,313, \
 314,258,308,308,260,260,310,310,311,311,312,312,327,313,314,314, \
 315,315,309,309,310,310,311,311,312,312,327,327,328,328,329,315, \
 329,321,330,322,347,315,348,348,317,285,310,310,311,311,312,312, \
 329,321,330,330,347,315,316,316,317,317,310,310,311,311,312,312, \
 313,313,322,322,323,315,324,332,381,317,382,382,311,327,328,384, \
 329,329,330,378,315,323,324,348,325,325,382,382,311,383,384,312, \
 347,347,330,348,367,322,323,359,324,324,325,325,326,326,327,372, \
 355,400,329,365,366,366,367,358,359,368,378,378,361,361,380,371, \
 372,381,373,355,356,383,384,384,376,376,377,395,396,387,325,325, \
 326,326,327,390,310,310,311,311,312,312,313,394,395,386,414,387, \
 319,419,330,330,331,381,382,382,343,393,334,364,395,405,396,326, \
 417,327,338,338,339,329,400,350,401,371,402,362,353,373,374,384, \
 355,355,346,346,347,347,558,558,329,369,370,370,561,561,562,562, \
 563,393,564,554,555,555,546,556,377,377,558,548,559,549,390,560, \
 552,552,553,553,554,554,555,544,545,556,546,546,558,547,548,548, \
 549,549,550,550,562,551,552,552,553,553,554,554,555,555,556,556, \
 557,557,558,558,548,559,549,560,550,550,562,562,552,563,564,564, \
 576,554,544,555,545,545,546,546,558,558,548,559,549,571,550,561, \
 545,545,558,558,559,571,560,560,561,549,550,550,563,563,552,552, \
 553,553,554,554,555,555,556,556,557,557,558,558,559,559,560,560, \
 561,561,562,562,563,563,564,564,553,553,554,554,555,555,556,556, \
 557,557,558,558,559,559,560,560,561,561,562,562,563,563,564,564, \
 567,554,555,555,569,595,557,544,545,545,598,546,560,547,600,561, \
 562,562,563,550,551,551,552,552,592,553,554,554,555,542,595,569, \
 544,544,545,558,559,559,560,560,561,561,562,562,563,563,564,564, \
 552,552,553,553,554,554,555,555,569,569,570,570,558,558,559,572, \
 557,557,558,558,559,559,560,560,561,561,562,562,563,563,564,564, \
 593,565,594,580,567,595,554,596,597,583,584,584,585,599,600,600, \
 559,559,560,560,561,561,562,562,563,563,564,564,593,593,594,594, \
 595,595,596,596,597,597,584,584,585,599,600,600,587,601,602,588, \
 599,599,600,585,571,586,587,587,588,588,589,604,605,605,591,591, \
 592,592,593,608,609,609,580,595,596,596,597,597,598,598,599,599, \
 600,600,601,601,602,602,603,558,634,589,590,635,576,576,667,562, \
 563,608,594,594,580,580,671,596,597,597,598,583,584,599,585,585, \
 593,593,594,594,595,595,596,596,677,597,598,598,599,599,600,600, \
 601,601,602,602,603,603,636,636,669,605,670,590,591,671,672,592, \
 705,705,706,706,563,707,708,708,693,597,710,598,599,631,584,584, \
 713,585,586,586,715,603,780,588,589,589,590,590,591,671,736,608 \
  
#define MPFR_SQRHIGH_TAB  \
 -1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,8, \
 9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16, \
 17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24, \
 25,25,26,26,27,27,28,28,29,29,30,30,31,32,32,32, \
 33,33,34,34,35,35,36,36,37,37,38,38,39,39,40,40, \
 41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48, \
 49,49,54,50,51,51,54,52,53,53,56,54,55,55,66,56, \
 57,57,58,58,59,59,60,60,61,61,62,62,63,63,64,66, \
 65,65,72,66,73,73,71,68,72,84,76,76,80,80,81,84, \
 79,85,80,80,84,84,88,88,92,92,96,96,88,88,95,92, \
 96,84,100,88,92,104,105,108,103,100,110,107,108,108,88,88, \
 116,116,90,90,91,94,92,92,93,93,94,94,95,95,96,96, \
 97,97,98,98,99,99,100,100,101,101,102,102,103,103,104,104, \
 105,113,106,106,107,107,108,108,109,109,110,114,115,111,112,112, \
 113,113,114,114,115,115,116,116,117,117,138,138,135,131,128,128, \
 141,141,130,134,131,135,140,140,153,137,138,138,155,147,144,140, \
 154,159,140,140,161,146,147,147,138,158,159,159,165,155,171,161, \
 157,162,168,168,169,159,160,165,166,171,167,157,168,168,174,159, \
 165,160,161,171,177,167,168,183,189,159,165,170,171,186,177,182, \
 178,168,164,159,160,195,181,156,192,177,183,173,174,174,170,165, \
 191,161,168,162,163,163,188,182,195,165,166,166,167,185,168,168, \
 169,169,170,194,195,171,172,214,185,173,192,186,175,187,182,236, \
 225,225,244,178,191,185,186,192,181,193,194,248,249,189,196,238, \
 239,215,264,222,187,235,224,188,261,237,190,268,191,191,192,216, \
 228,193,271,215,216,223,224,224,225,225,233,233,220,213,228,235, \
 236,236,237,237,273,238,246,225,240,261,276,269,235,249,264,243, \
 272,272,259,259,260,260,296,233,276,276,270,284,264,264,272,237, \
 259,273,246,246,282,240,248,269,270,249,264,264,272,272,273,280, \
 225,273,274,282,227,283,284,228,261,285,270,286,287,295,232,232, \
 297,233,234,234,307,235,236,236,237,285,286,278,287,287,240,312, \
 249,297,242,242,243,259,260,260,261,245,246,246,247,247,248,248, \
 249,249,250,250,251,251,252,276,253,333,254,254,255,255,272,256, \
 257,257,258,258,259,259,260,260,261,261,262,262,263,263,264,273, \
 265,265,266,284,285,285,268,268,269,269,270,279,271,271,272,272, \
 273,273,283,274,275,275,276,276,277,277,278,278,279,279,280,280, \
 281,281,282,282,283,283,284,284,285,321,286,286,287,287,288,288, \
 289,319,330,320,321,291,292,292,333,333,294,294,295,295,296,296, \
 297,297,308,338,309,299,320,300,321,321,302,312,323,323,324,314, \
 325,315,326,316,317,317,318,328,309,309,330,340,311,321,332,332, \
 333,323,324,324,335,335,336,336,337,347,348,338,349,339,350,330, \
 332,332,333,333,323,345,335,346,336,391,348,392,393,338,350,361, \
 362,362,363,363,419,353,365,376,366,399,411,400,412,379,380,380, \
 414,414,382,382,383,383,384,384,396,385,397,419,398,420,399,399, \
 411,433,434,401,402,402,414,403,415,393,416,405,417,406,407,407, \
 413,401,402,402,415,415,416,404,405,417,406,418,419,407,408,420, \
 409,433,422,398,399,411,412,436,437,473,438,474,427,427,440,428, \
 429,417,490,418,419,455,456,456,433,469,470,470,471,435,436,472, \
 473,473,474,474,463,463,464,488,453,465,454,466,479,467,480,456, \
 476,476,477,464,478,491,479,479,467,467,468,455,456,482,483,483, \
 471,471,472,472,499,499,500,474,501,501,463,489,477,490,504,491, \
 479,492,493,480,429,481,482,469,470,522,510,471,472,472,473,486, \
 487,487,488,501,489,528,477,503,543,504,505,531,545,506,520,520, \
 473,543,474,544,517,545,546,546,561,533,534,534,535,549,550,522, \
 481,481,482,482,483,525,498,526,527,499,500,486,487,487,474,558, \
 489,489,490,490,491,561,562,562,563,577,564,508,495,579,580,510, \
 581,581,582,582,499,555,528,528,557,501,530,516,517,489,490,490, \
 524,509,510,495,526,526,527,512,528,528,529,499,485,485,501,471, \
 472,472,473,578,474,579,580,490,476,581,582,582,508,598,599,554, \
 540,510,526,526,497,557,558,558,559,574,560,575,576,501,517,517, \
 518,503,579,504,580,565,581,566,522,582,523,583,479,524,480,480, \
 481,545,546,530,531,563,564,500,501,581,566,566,567,519,552,552, \
 553,553,490,554,539,555,492,556,557,509,526,574,575,495,496,496, \
 497,561,706,562,707,707,708,708,501,549,534,534,535,551,552,712, \
 713,521,570,570,571,715,508,588,717,541,558,510,543,735,576,528 \
  
#define MPFR_MUL_THRESHOLD 5 /* limbs */
#define MPFR_EXP_2_THRESHOLD 844 /* bits */
#define MPFR_EXP_THRESHOLD 9130 /* bits */

#elif defined (HAVE_HOST_CORE2) && defined (__i386) /* 32-bit Core 2,
      for example a 64-bit machine with gmp/mpfr compiled with ABI=32 */

/* Generated by MPFR's tuneup.c, 2007-12-21, gcc 4.1 */

#define MPFR_MULHIGH_TAB  \
 -1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28, \
 30,28,30,28,28,32,30,30,30,32,32,34,32,32,32,32, \
 33,35,44,40,35,41,40,42,41,47,48,48,47,51,56,48, \
 47,55,48,56,51,55,56,60,55,55,56,56,55,55,56,64, \
 63,59,60,64,59,59,64,64,63,63,60,68,63,67,60,64, \
 67,67,64,68,63,81,64,64,81,81,64,80,81,81,92,86, \
 86,80,81,81,79,91,86,92,93,84,85,85,86,86,87,87, \
 91,88,89,98,99,96,91,91,92,92,93,93,94,91,92,92, \
 99,99,103,97,98,98,96,93,121,115,104,116,93,99,121,127, \
 128,110,129,117,121,127,128,128,129,126,124,127,122,128,123,129, \
 129,129,134,138,139,139,140,140,129,141,122,138,139,139,128,128, \
 129,165,162,138,139,139,164,164,165,153,138,162,139,139,164,140, \
 165,165,150,146,139,163,164,164,141,177,158,162,151,151,160,156, \
 165,153,162,158,163,163,164,164,165,153,174,174,163,163,164,164, \
 164,164,165,165,176,176,172,177,168,163,189,189,165,165,176,176, \
 177,177,188,188,189,189,175,180,176,176,177,177,188,183,184,189, \
 180,180,191,201,192,177,188,188,189,199,200,200,201,201,212,212, \
 213,188,189,189,200,200,201,201,177,212,188,213,189,189,200,195, \
 239,239,240,240,199,199,212,212,213,201,232,196,215,197,240,240, \
 247,211,200,236,237,213,256,256,239,257,240,240,247,247,254,248, \
 237,255,256,238,257,257,240,240,253,247,272,272,237,237,256,256, \
 275,257,258,276,265,271,272,254,255,267,274,256,257,257,258,276, \
 256,249,257,285,258,258,266,294,267,267,275,275,276,276,291,270, \
 257,257,258,293,273,294,274,267,261,261,276,276,270,277,278,271, \
 293,293,294,294,267,267,268,275,276,276,284,284,292,271,272,293, \
 294,273,274,274,275,289,276,276,291,291,285,285,293,293,294,294, \
 321,305,290,290,291,275,276,348,285,293,294,310,311,303,312,288, \
 289,329,330,306,347,291,292,348,381,381,294,294,327,343,384,384, \
 345,337,306,346,347,307,308,340,341,381,366,366,343,383,384,384, \
 345,329,330,330,347,339,380,380,357,381,366,358,359,375,376,376, \
 383,383,366,366,340,367,368,359,360,360,361,379,362,362,417,381, \
 364,382,383,383,384,384,412,376,413,359,360,378,361,379,380,416, \
 417,381,382,418,419,365,384,384,412,412,413,377,378,378,379,379, \
 380,380,381,363,418,382,383,383,384,384,385,376,377,413,414,378, \
 379,379,380,380,381,381,382,382,383,363,364,414,415,365,366,366, \
 417,377,378,418,379,419,420,420,491,441,492,492,403,383,384,384, \
 415,415,386,416,417,417,418,418,419,419,420,490,491,491,492,492, \
 423,483,414,414,415,525,416,486,497,417,418,418,419,489,490,490, \
 486,420,487,421,488,455,456,423,424,490,491,491,492,492,471,471, \
 483,417,418,528,419,419,420,420,465,487,488,488,489,456,490,490, \
 491,491,492,492,526,493,527,494,484,528,419,452,453,486,487,454, \
 455,488,489,467,468,490,491,480,492,492,482,482,483,527,528,506, \
 521,485,522,498,487,487,488,524,525,489,490,490,491,491,492,528, \
 481,505,506,494,495,495,496,520,497,497,486,498,487,487,488,524, \
 489,489,490,526,527,491,492,492,529,529,506,518,519,483,496,484, \
 485,569,510,522,523,487,488,488,489,489,490,490,491,491,492,492, \
 528,528,490,490,491,491,492,492,506,506,507,507,521,521,535,522, \
 523,523,524,563,564,525,526,526,527,527,528,528,529,542,543,556, \
 570,557,571,558,533,533,534,560,535,522,523,536,537,563,564,525, \
 526,526,527,527,528,528,542,594,595,543,557,557,597,532,559,559, \
 557,557,558,558,559,531,546,560,561,547,548,562,563,563,564,564, \
 565,565,566,566,567,553,582,568,569,583,584,584,585,557,558,600, \
 559,573,560,588,533,561,590,562,563,563,564,564,593,579,594,566, \
 567,581,582,568,569,569,598,584,571,585,600,600,629,559,560,560, \
 599,599,600,600,601,586,587,602,603,603,634,604,605,635,636,636, \
 562,637,638,563,564,564,565,565,566,611,612,552,628,568,569,584, \
 585,600,631,616,617,632,633,633,634,634,635,635,636,606,592,712, \
 713,638,639,564,595,715,716,716,717,597,583,568,569,704,600,585, \
 625,593,594,770,771,595,596,708,597,597,598,694,695,599,600,712, \
 633,633,714,634,715,715,716,636,717,717,686,750,751,751,752,768, \
 753,753,754,770,771,771,756,708,709,709,710,742,743,711,712,760, \
 761,713,714,714,715,715,716,716,765,717,718,750,751,751,768,736 \
  
#define MPFR_SQRHIGH_TAB  \
 -1,0,-1,-1,0,0,0,0,0,0,0,0,-1,-1,0,8, \
 9,9,10,10,11,12,12,13,13,13,14,14,15,15,16,16, \
 17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24, \
 25,25,26,26,27,27,28,28,29,29,30,30,31,31,32,32, \
 33,33,34,34,35,35,36,36,37,37,38,42,39,39,40,40, \
 41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48, \
 49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56, \
 57,57,58,58,59,59,60,60,61,61,62,62,63,63,64,64, \
 65,74,66,66,67,67,68,68,69,78,70,70,74,71,72,72, \
 73,73,74,74,75,75,76,76,77,77,78,78,79,79,80,80, \
 81,84,82,82,83,83,84,84,85,85,92,92,87,87,88,88, \
 89,89,90,96,91,91,92,92,93,96,100,100,95,95,96,96, \
 97,97,98,98,99,99,100,100,101,101,114,102,103,103,104,104, \
 105,105,114,106,107,123,108,108,117,109,110,110,111,111,112,112, \
 113,113,114,114,115,115,116,116,117,117,118,118,119,119,120,132, \
 141,121,122,122,123,135,140,144,141,125,126,126,127,127,128,128, \
 129,129,130,135,131,131,132,132,133,158,134,134,135,135,136,136, \
 137,137,138,138,169,139,140,140,141,141,142,142,143,143,144,144, \
 145,145,146,171,177,147,153,148,149,159,150,150,151,171,177,177, \
 153,153,154,159,180,165,156,156,157,177,183,168,159,159,170,165, \
 161,161,162,162,163,163,164,164,165,165,166,166,167,167,168,168, \
 169,169,170,170,171,171,172,172,173,173,174,174,175,175,176,176, \
 177,177,178,178,179,179,180,180,181,181,182,182,183,183,184,184, \
 185,185,186,186,187,187,188,188,189,189,190,190,191,191,192,192, \
 193,193,194,194,195,195,196,196,197,197,198,198,199,199,200,200, \
 201,201,202,202,203,210,225,204,205,205,206,206,207,207,208,208, \
 209,209,210,210,211,211,212,212,213,213,214,214,215,215,216,216, \
 217,217,218,218,219,219,220,220,221,221,222,222,223,223,224,224, \
 225,225,226,226,227,227,228,228,229,229,230,230,231,231,232,232, \
 233,249,234,234,235,235,236,236,237,237,238,238,239,239,240,240, \
 241,241,242,242,243,243,244,244,245,245,246,246,247,247,248,248, \
 249,249,250,250,251,251,252,252,253,253,254,254,255,255,256,256, \
 257,257,258,258,259,259,260,260,261,261,262,262,263,263,264,264, \
 265,283,266,284,285,267,268,268,269,269,270,270,271,271,272,272, \
 273,273,274,274,275,275,276,276,277,277,278,278,279,279,280,280, \
 281,281,282,282,283,283,284,284,285,285,286,295,332,287,288,288, \
 289,309,320,320,321,291,292,292,293,293,294,324,295,295,296,296, \
 297,297,298,298,299,299,300,300,301,301,302,302,303,333,304,304, \
 345,305,306,306,307,307,348,338,339,309,310,310,311,311,312,312, \
 333,323,324,354,355,345,336,316,317,337,338,338,319,339,320,340, \
 365,365,344,333,323,345,346,324,325,347,348,348,349,327,328,328, \
 384,329,330,330,331,364,332,354,366,366,356,356,357,335,336,336, \
 337,337,338,338,339,383,384,340,341,341,342,342,343,343,344,344, \
 345,345,346,346,347,347,348,348,349,382,383,350,351,351,352,352, \
 353,353,402,354,355,355,356,356,357,357,358,358,359,419,420,420, \
 361,361,362,362,363,363,364,364,365,365,366,366,367,367,368,368, \
 369,369,370,370,371,371,372,372,373,373,374,374,375,375,376,376, \
 377,377,378,378,379,379,380,380,381,381,382,382,383,383,384,384, \
 385,385,399,490,387,387,388,388,389,389,390,390,391,391,392,392, \
 393,393,420,394,395,395,396,396,397,397,398,398,399,399,400,400, \
 401,401,402,402,507,507,508,404,405,509,510,510,407,407,408,473, \
 474,474,527,436,437,411,412,412,413,491,492,492,415,415,416,416, \
 417,417,418,418,419,419,420,420,421,463,492,492,521,479,480,424, \
 425,425,426,426,427,427,428,484,429,429,430,472,473,473,474,432, \
 433,433,434,504,491,491,492,436,437,507,508,508,481,467,468,468, \
 469,483,484,512,513,471,486,500,501,515,516,488,489,447,448,490, \
 509,509,510,510,481,526,527,512,513,528,544,544,545,455,456,456, \
 517,487,488,488,489,489,490,460,461,461,462,492,508,508,509,509, \
 510,510,511,526,527,467,468,528,544,469,470,515,546,531,517,472, \
 473,473,474,474,475,535,581,476,477,477,478,478,479,479,480,480, \
 481,481,482,482,483,547,548,484,485,485,486,566,535,487,488,488, \
 489,489,490,490,491,491,492,492,493,493,494,494,495,495,496,496, \
 497,561,498,578,579,579,580,580,581,501,502,598,599,503,504,504, \
 505,505,506,506,507,507,508,508,509,509,510,510,511,511,512,512 \
  
#define MPFR_MUL_THRESHOLD 11 /* limbs */
#define MPFR_EXP_2_THRESHOLD 441 /* bits */
#define MPFR_EXP_THRESHOLD 9145 /* bits */
/* Tuneup completed successfully, took 74 seconds */

/****************************
 * Threshold for AMD 64     *
 ****************************/
#elif defined (__amd64)

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 14,13,0,10,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,32,0,0,32,0, \
 0,0,36,0,0,36,0,0,37,0,0,38,0,39,40,0, \
 41,42,0,42,44,43,44,46,45,46,52,64,48,64,64,52, \
 63,64,63,64,64,63,64,64,63,64,63,64,64,63,64,63, \
 64,68,64,68,64,68,76,68,72,68,72,68,72,68,72,80, \
 72,70,75,80,76,84,76,80,76,80,76,84,80,84,80,92, \
 84,88,80,88,86,80,84,82,92,84,92,88,96,88,92,90, \
 88,92,93,88,92,127,128,128,128,128,127,127,127,126,127,128, \
 126,127,128,127,128,126,128,126,127,128,127,127,128,127,128,127, \
 126,127,128,128,128,128,127,136,127,128,127,128,135,127,128,135, \
 127,128,135,136,144,135,127,127,135,136,127,128,126,127,128,126, \
 127,128,135,136,128,132,136,128,127,136,140,135,136,134,136,136, \
 135,136,134,135,142,148,143,144,133,152,142,152,144,148,160,142, \
 136,152,150,160,160,148,152,160,159,152,156,159,160,151,160,164, \
 152,158,175,158,158,157,158,160,160,168,160,165,164,167,164,167, \
 160,176,166,176,165,160,167,192,183,184,176,179,176,168,175,176, \
 182,200,175,192,200,183,183,184,192,191,183,184,183,199,200,192, \
 183,180,200,182,189,180,187,200,208,257,191,190,257,200,254,208, \
 255,254,254,255,255,254,255,256,253,252,255,253,255,254,256,258, \
 252,253,254,255,253,254,255,254,263,254,254,255,256,254,254,255, \
 255,254,257,253,253,254,264,254,256,255,256,255,260,254,255,255, \
 253,254,255,256,254,254,263,263,254,254,255,255,255,264,255,256, \
 255,264,255,258,263,264,263,262,262,276,256,263,258,276,275,272, \
 264,259,275,272,259,288,281,255,256,275,287,258,284,262,255,262, \
 254,255,265,288,254,287,299,257,288,255,257,263,254,257,324,267, \
 258,259,264,261,262,256,276,286,262,262,263,274,261,276,276,275, \
 274,275,276,282,384,275,276,276,383,288,380,382,382,379,379,382, \
 383,384,382,380,379,383,379,379,383,380,384,381,381,383,379,379, \
 379,379,383,384,382,383,382,382,381,384,379,383,380,381,383,384, \
 381,382,381,379,383,383,379,379,381,379,382,384,384,380,381,383, \
 379,384,380,384,382,379,382,383,380,381,381,383,382,382,384,379, \
 382,377,382,382,379,379,379,382,380,381,382,380,380,379,380,379, \
 380,383,380,383,382,380,381,379,380,382,379,382,382,383,384,384, \
 382,380,384,382,383,382,379,379,390,407,401,380,381,382,383,384, \
 398,408,383,383,400,384,395,386,381,384,408,407,382,383,384,395, \
 430,406,383,402,384,383,432,404,383,383,383,431,398,408,403,406, \
 394,396,396,389,431,407,431,430,383,384,404,428,400,443,404,403, \
 401,453,430,404,431,431,407,396,426,400,431,429,407,444,432,456, \
 431,408,407,408,427,431,408,403,431,454,428,431,419,456,407,431, \
 456,437,417,428,425,455,453,430,452,454,454,432,430,455,432,430, \
 452,451,430,452,455,430,428,479,430,432,439,448,449,476,456,431, \
 478,431,446,450,449,455,472,478,479,357,382,358,375,360,361,364, \
 369,369,367,365,379,370,369,371,386,368,366,374,378,369,376,375, \
 374,369,379,378,390,380,392,372,381,375,384,396,385,379,376,387, \
 378,391,385,392,393,381,380,380,381,387,382,384,405,385,384,406, \
 402,387,388,386,394,399,401,405,396,407,390,397,396,395,409,409, \
 397,440,396,403,414,411,406,396,411,397,407,405,417,420,416,421, \
 404,403,405,402,415,422,412,428,410,425,413,408,421,417,409,408, \
 414,436,425,415,424,411,415,413,426,413,422,427,415,415,416,451, \
 429,417,423,418,424,429,420,432,421,422,449,422,423,423,433,425, \
 425,425,427,427,443,446,429,449,435,438,434,439,453,442,443,444, \
 455,439,437,435,437,441,447,446,457,444,453,438,452,462,446,445, \
 449,471,446,451,463,451,471,458,464,449,452,453,457,458,473,460, \
 450,464,469,458,465,458,457,458,453,483,456,463,470,517,474,467, \
 458,458,466,540,490,504,477,493,478,524,490,520,463,491,477,509, \
 519,502,490,507,517,521,504,525,527,524,537,536,543,551,565,645, \
 600,564,568,571,682,586,601,573,663,495,708,762,765,767,763,767, \
 757,660,767,775,763,785,759,764,764,757,757,763,778,767,758,763, \
 761,758,767,762,763,764,788,767,757,765,767,758,757,773,760,760, \
 759,761,758,765,758,763,760,763,759,763,761,757,760,766,791,760, \
 763,782,760,761,760,763,764,764,764,766,764,759,757,758,763,763 \
  
#define MPFR_MUL_THRESHOLD 4
#define MPFR_EXP_2_THRESHOLD 524
#define MPFR_EXP_THRESHOLD 22876

/*****************************
 * Threshold for Athlon      *
 *****************************/
#elif defined (__athlon)

#define MPFR_MULHIGH_TAB  \
 -1,0,-1,0,-1,0,-1,-1,0,-1,-1,0,0,0,0,10, \
 0,12,13,14,15,16,0,0,0,0,0,19,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32, \
 30,32,30,34,32,32,36,34,36,36,38,38,42,38,38,42, \
 40,38,42,46,42,42,42,44,44,44,44,44,48,50,46,46, \
 60,50,50,48,50,56,56,56,56,56,56,56,60,60,64,60, \
 64,64,60,60,60,72,64,64,68,72,76,72,76,72,72,76, \
 75,76,76,72,76,72,75,72,72,72,84,76,84,75,72,76, \
 84,80,76,84,84,76,76,76,76,88,84,88,80,84,83,96, \
 84,96,92,84,88,91,92,88,92,90,96,96,92,91,92,96, \
 96,120,95,100,112,120,100,119,112,120,120,112,119,112,119,119, \
 120,118,119,119,119,118,119,120,128,127,120,128,128,120,120,127, \
 120,128,128,128,128,120,128,127,120,128,128,127,128,127,144,136, \
 128,144,152,152,152,136,144,144,144,136,151,152,144,152,128,151, \
 144,152,144,144,151,144,150,150,136,151,152,143,143,143,142,168, \
 144,144,168,151,168,144,152,151,152,152,160,152,151,152,160,151, \
 152,151,152,167,152,152,166,152,167,160,168,204,160,160,168,168, \
 204,176,202,167,168,166,167,168,204,184,202,204,204,204,204,192, \
 184,192,204,202,202,216,204,227,202,204,216,203,203,204,203,227, \
 202,204,202,202,202,203,202,215,204,202,203,202,202,215,228,214, \
 226,214,228,214,228,215,228,216,226,214,228,225,226,228,226,226, \
 226,215,216,216,226,225,226,227,216,227,240,216,252,252,226,227, \
 228,239,227,250,227,226,227,227,252,238,228,239,252,227,228,228, \
 252,226,246,228,227,227,252,247,250,263,262,250,252,250,250,252, \
 250,288,288,250,250,250,251,264,264,271,287,276,250,288,252,286, \
 251,287,288,251,276,274,288,262,263,263,282,252,288,252,276,284, \
 287,274,264,274,288,275,275,274,274,288,276,264,273,286,274,276, \
 300,287,288,286,286,276,288,285,275,300,275,273,275,299,300,299, \
 279,336,336,286,287,284,360,359,336,335,288,360,333,359,334,335, \
 335,287,359,335,336,336,359,333,334,359,360,288,360,332,335,336, \
 335,336,336,333,336,335,336,359,334,334,335,360,336,334,356,357, \
 335,336,358,359,359,336,335,336,334,355,384,356,354,384,334,357, \
 336,359,384,359,360,356,384,382,336,383,384,384,354,355,383,384, \
 382,359,384,382,382,383,383,359,381,382,383,356,384,382,381,384, \
 357,384,358,357,358,358,380,383,382,382,383,360,360,381,382,360, \
 377,360,378,360,360,381,382,383,381,380,383,383,360,382,383,380, \
 383,383,384,381,379,360,381,381,382,431,380,380,378,380,384,381, \
 382,382,384,407,384,382,379,384,430,431,383,384,408,384,456,431, \
 431,455,431,428,384,454,455,403,432,383,407,430,430,456,408,427, \
 455,455,456,455,432,431,431,429,455,432,432,424,430,427,427,429, \
 452,454,426,455,456,431,430,454,452,454,431,456,431,428,455,430, \
 454,430,432,455,454,442,443,432,443,431,451,452,456,430,451,456, \
 444,455,449,456,432,454,449,454,502,432,448,504,450,503,503,453, \
 454,502,446,452,453,454,455,499,504,453,456,504,454,453,503,455, \
 456,456,500,478,502,454,456,499,478,454,480,499,501,496,502,455, \
 499,502,503,456,478,500,501,500,479,503,504,451,452,479,454,455, \
 502,503,504,504,454,499,503,501,454,503,456,503,504,501,455,502, \
 503,503,502,504,610,503,504,574,480,551,528,504,609,576,480,503, \
 496,502,503,552,551,552,551,503,504,503,610,608,609,610,611,608, \
 608,551,648,611,612,550,576,572,608,611,610,606,608,611,610,574, \
 575,576,606,607,606,606,608,606,606,575,576,604,604,604,608,609, \
 606,606,606,608,604,604,611,604,604,576,610,606,610,606,604,610, \
 606,612,604,608,610,609,604,608,606,647,612,610,604,606,648,610, \
 610,606,646,608,604,647,606,647,606,609,610,647,648,609,641,611, \
 643,611,643,648,643,640,646,611,644,644,645,611,642,646,611,612, \
 640,647,610,611,610,611,606,647,648,647,648,644,682,642,682,683, \
 610,611,680,678,642,681,682,647,682,612,682,648,611,665,680,683, \
 609,646,666,676,680,646,679,647,646,646,648,679,684,611,612,643, \
 684,645,646,647,683,647,608,645,682,647,682,646,610,648,682,610, \
 684,612,612,683,684,647,647,646,680,646,646,745,648,646,644,647, \
 648,647,678,646,647,683,642,682,682,684,646,645,642,647,646,677, \
 646,647,683,678,680,646,646,643,681,647,683,645,666,755,756,645, \
 643,647,646,647,647,648,674,755,756,674,647,643,680,682,684,680, \
 680,682,682,675,682,677,666,683,680,682,682,684,680,681,674,674 \
  
#define MPFR_MUL_THRESHOLD 19
#define MPFR_EXP_2_THRESHOLD 411
#define MPFR_EXP_THRESHOLD 45200

/*****************************
 * Threshold for PentiumPro  *
 *****************************/
#elif defined (__i386)

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,64,64,56,64,64, \
 64,64,64,64,64,64,63,63,63,63,63,63,63,64,64,64, \
 64,63,64,64,63,63,63,80,80,72,64,80,72,80,80,79, \
 79,79,79,79,80,80,80,80,96,96,96,95,96,96,94,96, \
 95,95,95,96,95,95,96,96,95,95,95,95,96,96,104,96, \
 96,95,104,103,96,104,96,96,96,128,104,104,128,127,128,128, \
 128,128,128,128,126,128,126,127,127,127,128,127,127,127,127,127, \
 126,126,126,126,126,126,126,126,127,127,128,128,126,127,126,128, \
 128,128,128,128,126,127,126,128,128,125,124,127,126,126,126,126, \
 128,128,128,127,127,128,168,160,166,128,159,159,160,192,192,168, \
 167,167,190,192,190,168,190,191,180,188,167,191,191,190,190,190, \
 190,192,191,192,190,191,190,191,190,192,188,191,192,190,190,192, \
 192,189,190,192,191,192,190,192,191,186,188,189,190,188,191,190, \
 192,192,189,189,191,192,190,189,190,190,187,188,188,190,190,192, \
 190,191,191,191,216,192,216,190,192,191,189,216,190,215,191,190, \
 215,189,190,190,192,216,190,190,192,192,190,239,192,192,228,240, \
 239,237,237,238,228,215,236,237,232,230,237,215,192,236,216,234, \
 237,232,236,239,230,256,245,288,285,240,239,248,214,236,257,256, \
 284,288,287,256,239,262,284,288,341,243,216,285,285,280,287,269, \
 286,285,286,286,286,286,286,284,281,281,284,285,283,284,283,273, \
 286,285,276,283,287,286,287,286,282,286,288,288,287,283,288,281, \
 282,280,286,283,284,280,285,280,288,284,283,283,283,283,287,288, \
 281,286,284,284,286,287,286,288,281,288,286,281,286,287,286,287, \
 312,284,288,286,311,288,285,286,312,280,283,308,284,310,287,285, \
 283,286,311,288,287,288,287,311,286,286,287,384,335,334,383,383, \
 333,380,335,312,382,382,384,383,312,311,381,377,382,384,379,379, \
 380,383,384,384,381,381,383,377,381,384,383,383,383,382,384,335, \
 336,384,377,377,379,384,377,382,379,383,379,378,377,377,376,380, \
 377,382,383,380,379,380,381,384,383,377,375,380,383,381,380,378, \
 379,376,380,378,383,374,376,376,375,384,382,376,384,383,377,377, \
 384,380,384,382,383,382,382,377,379,378,384,379,381,383,384,378, \
 383,377,376,381,383,383,379,379,381,377,381,384,377,380,380,384, \
 383,383,384,383,381,377,374,380,379,381,377,378,374,380,376,377, \
 376,383,383,379,380,383,384,383,430,383,381,382,374,382,379,501, \
 379,383,384,382,503,382,497,379,492,380,501,381,383,382,501,502, \
 495,502,499,380,384,498,381,384,498,384,499,499,502,480,497,495, \
 480,478,498,497,502,496,500,503,479,502,501,503,475,492,498,496, \
 479,504,500,492,498,496,500,500,499,494,494,504,492,494,495,496, \
 497,494,504,503,492,494,500,497,575,502,504,496,497,496,575,572, \
 570,502,503,574,568,568,569,502,571,572,568,504,570,569,573,576, \
 574,570,538,566,538,565,566,572,569,568,572,571,568,571,575,569, \
 564,571,568,575,568,576,561,567,560,576,562,573,568,574,572,575, \
 575,564,568,574,574,575,572,568,568,570,572,574,568,576,575,564, \
 572,573,570,564,574,576,574,574,567,566,570,575,571,576,570,573, \
 573,569,567,568,572,574,566,572,573,574,568,570,570,567,566,561, \
 557,571,564,560,557,562,574,563,576,571,557,569,572,575,571,564, \
 572,558,566,562,559,574,563,574,571,569,572,568,574,570,571,566, \
 571,568,566,566,565,572,570,568,572,572,565,575,569,566,567,575, \
 571,573,573,572,563,569,576,567,568,568,569,566,570,568,573,569, \
 570,573,570,574,574,575,574,568,575,568,564,568,567,571,576,576, \
 568,569,575,569,569,573,574,575,573,574,565,571,567,568,568,575, \
 571,569,573,575,575,570,570,571,565,569,571,571,643,648,571,575, \
 576,570,574,576,574,645,572,642,648,644,646,576,575,648,634,719, \
 573,645,644,643,570,641,638,641,574,644,644,645,644,638,637,574, \
 574,575,576,572,642,719,645,648,713,645,682,709,713,718,720,712, \
 645,718,719,716,644,698,682,678,707,647,681,682,716,684,681,682, \
 683,716,715,719,708,706,719,706,709,708,712,708,709,712,715,712, \
 720,717,717,718,717,704,705,706,707,718,700,710,708,708,713,683, \
 719,717,717,718,719,720,710,709,713,705,711,684,717,718,710,717 \
  
#define MPFR_MUL_THRESHOLD 11
#define MPFR_EXP_2_THRESHOLD 528
#define MPFR_EXP_THRESHOLD 47120

/*****************************
 * Threshold for IA64        *
 *****************************/
#elif defined (__ia64)

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0, \
 128,124,124,124,124,124,120,124,120,124,120,124,120,124,124,124, \
 124,124,124,124,144,124,144,140,140,140,140,136,136,136,136,136, \
 136,136,136,136,136,136,136,136,136,136,136,136,140,139,140,152, \
 152,152,160,156,160,156,160,164,156,156,160,156,144,160,147,160, \
 160,159,160,160,160,168,168,168,160,164,176,168,172,168,156,168, \
 168,164,168,176,172,172,160,175,168,172,176,172,176,175,176,184, \
 176,175,176,180,176,180,184,184,168,180,184,184,184,171,172,207, \
 184,184,184,208,200,207,176,207,200,200,208,206,208,200,208,206, \
 200,200,206,207,206,207,208,207,207,206,208,207,208,208,208,208, \
 208,207,224,207,208,240,215,215,240,215,240,239,216,215,216,240, \
 224,223,224,220,222,220,224,223,224,223,224,231,224,223,232,228, \
 256,255,231,231,256,231,232,232,232,255,256,255,238,264,238,238, \
 256,255,256,248,256,264,240,239,240,240,248,271,248,255,272,248, \
 264,255,256,255,256,252,256,256,272,255,256,255,256,263,264,264, \
 264,263,264,264,263,264,264,271,256,271,271,271,272,272,285,270, \
 285,271,280,271,280,280,280,272,280,287,269,279,284,271,280,271, \
 271,271,285,286,271,272,272,280,272,279,272,278,280,271,286,284, \
 271,280,272,277,284,272,336,281,312,279,280,278,280,280,280,280, \
 284,280,348,280,272,334,272,284,285,287,286,279,336,323,331,334, \
 332,331,332,335,286,346,336,332,334,336,334,336,334,341,358,347, \
 336,336,334,335,334,346,344,347,347,360,371,348,355,382,334,356, \
 336,355,347,384,336,358,358,345,357,347,346,347,348,359,371,359, \
 358,382,346,383,347,357,360,358,357,357,360,370,406,394,382,347, \
 406,347,407,408,407,406,365,419,356,395,356,359,358,406,360,406, \
 359,359,408,419,395,432,360,420,408,425,408,395,430,395,371,432, \
 370,401,432,396,384,419,384,406,359,378,379,378,382,380,392,384, \
 377,384,383,395,407,383,384,455,455,371,371,404,381,405,395,431, \
 432,432,408,400,384,383,383,455,455,377,455,438,432,419,420,444, \
 398,424,392,469,432,427,431,430,404,396,406,384,454,451,464,404, \
 428,432,432,429,405,432,444,407,452,473,430,453,443,452,456,430, \
 454,431,407,430,407,416,455,456,468,456,468,443,431,443,442,460, \
 419,448,467,449,448,478,428,448,479,455,467,431,450,478,431,491, \
 480,442,440,458,478,442,442,432,430,467,467,467,469,467,455,479, \
 453,479,451,478,503,443,454,479,473,476,480,473,477,480,479,489, \
 491,491,491,480,476,454,503,499,500,502,504,460,491,455,466,491, \
 480,477,477,476,473,502,502,504,527,490,467,500,489,502,501,503, \
 515,474,528,480,496,498,492,480,479,504,504,480,492,504,503,522, \
 515,491,503,540,491,499,503,552,492,503,500,504,502,526,551,528, \
 526,514,516,528,528,506,551,503,509,491,496,502,503,514,503,501, \
 548,503,504,552,512,515,516,504,506,509,551,548,502,491,504,552, \
 520,526,528,551,502,521,526,520,514,523,539,549,503,545,528,538, \
 504,533,504,520,511,515,528,504,538,516,514,526,514,528,521,599, \
 551,599,515,520,550,528,526,527,597,548,552,624,535,598,540,528, \
 534,530,596,532,623,539,617,540,542,551,552,550,617,549,600,624, \
 624,550,551,547,596,616,622,551,550,551,552,646,646,648,624,647, \
 622,619,623,622,647,599,600,672,646,647,622,623,624,643,647,647, \
 672,641,622,599,671,617,646,623,622,650,644,647,648,672,647,648, \
 622,641,646,647,648,659,624,644,646,672,647,623,647,648,664,645, \
 644,647,646,622,646,647,668,621,624,647,670,644,626,659,647,624, \
 648,647,647,635,682,695,641,665,646,634,645,646,672,670,646,693, \
 624,694,647,648,624,620,660,648,646,660,688,694,695,667,672,666 \
  
#define MPFR_MUL_THRESHOLD 10
#define MPFR_EXP_2_THRESHOLD 534
#define MPFR_EXP_THRESHOLD 20877

/* __mips64? __mips? */
#endif

/*******************************
 * Default values of Threshold *
 *******************************/
#ifndef MPFR_MULHIGH_TAB
# define MPFR_MULHIGH_TAB -1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0
#endif
#ifndef MPFR_SQRHIGH_TAB
# define MPFR_SQRHIGH_TAB -1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0
#endif
#ifndef MPFR_MUL_THRESHOLD
# define MPFR_MUL_THRESHOLD 40
#endif
#ifndef MPFR_EXP_2_THRESHOLD
# define MPFR_EXP_2_THRESHOLD 100
#endif
#ifndef MPFR_EXP_THRESHOLD
# define MPFR_EXP_THRESHOLD 25000
#endif
