/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFInputStream;
import de.tu_darmstadt.sp.paul.PDFInteger;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFReferenceContainer;
import de.tu_darmstadt.sp.paul.PDFStream;
import de.tu_darmstadt.sp.paul.PDFStreamException;
import de.tu_darmstadt.sp.paul.StreamFilterFactory;
import de.tu_darmstadt.sp.util.NCByteArrayOutputStream;
import de.tu_darmstadt.sp.util.VerbatimOutputStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class PDFOutputStream
extends PDFStream {
    ByteArrayOutputStream contentStream;
    private boolean writing;
    private OutputStream out;

    public PDFOutputStream() {
        this.dictionary = new PDFDictionary();
    }

    public PDFOutputStream(PDFDictionary dict) {
        this.dictionary = dict;
    }

    public PDFOutputStream(PDFInputStream source, List filters) {
        this.dictionary = (PDFDictionary)source.dictionary.clone();
        if (filters != null) {
            this.setFilters(filters, null);
        }
        OutputStream out = this.getOutputStream();
        InputStream in = source.getInputStream();
        try {
            int b = in.read();
            while (b != -1) {
                out.write(b);
                b = in.read();
            }
        }
        catch (IOException e) {
            throw new PDFStreamException(e.getMessage());
        }
        this.closeOutputStream();
    }

    public PDFOutputStream(PDFInputStream source, List filters, List parms) {
        this.dictionary = (PDFDictionary)source.dictionary.clone();
        if (filters != null) {
            this.setFilters(filters, parms);
        }
        OutputStream out = this.getOutputStream();
        InputStream in = source.getInputStream();
        try {
            int b = in.read();
            while (b != -1) {
                out.write(b);
                b = in.read();
            }
        }
        catch (IOException e) {
            throw new PDFStreamException(e.getMessage());
        }
        this.closeOutputStream();
    }

    public void changeFilters(List filters, List parms) throws PDFStreamException {
        if (this.writing) {
            throw new PDFStreamException("can't change filters while writing");
        }
        PDFOutputStream tmp = new PDFOutputStream(new PDFInputStream(this), filters, parms);
        this.dictionary = tmp.dictionary;
        this.contentStream = tmp.contentStream;
    }

    public void closeOutputStream() {
        if (this.out == null) {
            return;
        }
        try {
            this.out.close();
            this.out = null;
            this.writing = false;
        }
        catch (IOException e) {
            throw new PDFStreamException("IOException: " + e.getMessage());
        }
    }

    protected boolean deepEquiv(PDFReferenceContainer obj, Map compared) {
        PDFInputStream other;
        if (this.writing) {
            return false;
        }
        if (obj instanceof PDFOutputStream) {
            if (((PDFOutputStream)obj).writing) {
                return false;
            }
            other = new PDFInputStream((PDFOutputStream)obj);
        } else {
            other = (PDFInputStream)obj;
        }
        PDFInputStream me = new PDFInputStream(this);
        return me.deepEquiv(other, compared);
    }

    public OutputStream getOutputStream() {
        if (this.contentStream == null) {
            this.contentStream = new NCByteArrayOutputStream(this.getLength());
        }
        if (this.out != null) {
            return this.out;
        }
        this.out = this.contentStream;
        List filters = this.getFilters();
        List parms = this.getParms();
        int len = filters.size();
        int len2 = parms.size();
        int i = 0;
        while (i < len) {
            this.out = StreamFilterFactory.createOutputFilter(this.out, (PDFName)filters.get(i), len2 == 0 ? PDFObject.NULL : (PDFObject)parms.get(i));
            ++i;
        }
        this.writing = true;
        return this.out;
    }

    public void setFilter(PDFName filter) {
        this.setFilter(filter, null);
    }

    public void setFilter(PDFName filter, PDFObject parms) {
        if (this.writing) {
            throw new PDFStreamException("can't change filters while writing");
        }
        if (filter == null) {
            this.dictionary.remove(PDFName.FILTER);
            this.dictionary.remove(PDFName.DECODEPARMS);
            return;
        }
        this.dictionary.put(PDFName.FILTER, (PDFObject)filter);
        if (parms != null) {
            this.dictionary.put(PDFName.DECODEPARMS, parms);
        } else {
            this.dictionary.remove(PDFName.DECODEPARMS);
        }
    }

    public void setFilters(List filters) {
        this.setFilters(filters, null);
    }

    public void setFilters(List filters, List parms) {
        if (this.writing) {
            throw new PDFStreamException("can't change filters while writing");
        }
        if (filters == null || filters.size() == 0) {
            this.dictionary.remove(PDFName.FILTER);
            this.dictionary.remove(PDFName.DECODEPARMS);
            return;
        }
        if (filters.size() == 1) {
            if (parms == null) {
                this.setFilter((PDFName)filters.get(0));
            } else {
                this.setFilter((PDFName)filters.get(0), (PDFObject)parms.get(0));
            }
        }
        PDFArray newFilters = new PDFArray();
        PDFArray newParms = null;
        if (parms != null) {
            newParms = new PDFArray();
        } else {
            this.dictionary.remove(PDFName.DECODEPARMS);
        }
        int len = filters.size();
        int i = 0;
        while (i < len) {
            newFilters.add((PDFObject)filters.get(i));
            if (parms != null) {
                newParms.add((PDFObject)parms.get(i));
            }
            ++i;
        }
        this.dictionary.put(PDFName.FILTER, (PDFObject)newFilters);
        if (parms != null) {
            this.dictionary.put(PDFName.DECODEPARMS, (PDFObject)newParms);
        }
    }

    public void write(Writer out) throws IOException {
        this.closeOutputStream();
        byte[] streamContent = this.contentStream == null ? new byte[]{} : this.contentStream.toByteArray();
        int len = this.contentStream == null ? 0 : this.contentStream.size();
        this.dictionary.put(PDFName.LENGTH, (PDFObject)PDFInteger.forInt(len));
        this.dictionary.write(out);
        out.write("\nstream\n");
        if (out instanceof VerbatimOutputStreamWriter) {
            ((VerbatimOutputStreamWriter)out).write(streamContent, 0, len);
        } else {
            int i = 0;
            while (i < len) {
                out.write(streamContent[i]);
                ++i;
            }
        }
        out.write("endstream");
    }
}

