/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "member_gatherer.h"
 *                                    created: 1/11/97 {4:59:35 pm} 
 *                                last update: 05/08/98 {10:07:38 AM} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 * ========================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  1/11/97  VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_member_gatherer_
#define _Cpptcl_member_gatherer_

#include "cpptcl.h"
#include "cpptcl_member_base.icc"
#include "cpptcl_data_members.h"

DLL_IMPORT_EXPORT
class cpp_data_gatherer {
  public:
	tcl_object* from_obj;
	cpp_data_mem* from_member;
	tcl_object* container;
	cpp_data_gatherer(tcl_object* c):from_obj(0),from_member(0),container(c) {}
	virtual ~cpp_data_gatherer(void) {}
	bool ready(void) const { return (from_obj && from_member);}
	cpp_data_mem& connection(void) {
		from_member->operator()(from_obj); 
		return *from_member;
	}
	virtual operator bool (void) const=0;
	virtual operator int (void) const=0;
	virtual operator float (void) const=0;
	virtual operator double (void) const=0;
	virtual operator long (void) const=0;
};

template <class T>
class cpp_data_gatherer_t: public cpp_data_gatherer {
  public:
	 T minimum(void) const;
	 T maximum(void) const;
	 T value(void) const;
	cpp_data_gatherer_t<T>& operator() (tcl_object *obj) {
		from_obj = obj; return *this;
	}
	cpp_data_gatherer_t(tcl_object* c):cpp_data_gatherer(c) {}
	~cpp_data_gatherer_t(void) {}
	virtual operator bool (void) const { return (bool) value();}
	virtual operator int (void) const { return (int) value();}
	virtual operator float (void) const { return (float) value();}
	virtual operator double (void) const { return (double) value();}
	virtual operator long (void) const { return (long) value();}
	
};

typedef cpp_data_gatherer tcl_object::*cpp_data_gatherptr;

DLL_IMPORT_EXPORT
class member_gatherer: public cpp_config_mem {
	friend class cpp_member_info;
  protected:
	///
	member_gatherer(const member_gatherer& c):cpp_config_mem(c) {}
	///
	virtual cpp_data_gatherer& gatherer(void) const=0;
  public:
	///
	Cpptcl_BaseClass(member_gatherer);
	///
	member_gatherer(const char* n):cpp_config_mem(n) {}
	~member_gatherer(void) {}
    ///
	void tcl_get(tcl_object* o,tcl_obj& tcl) const {
		container = o;
		cpp_data_mem* rmem = gatherer().from_member;
		if(rmem) {
			rmem->operator()(gatherer().from_obj);
			tcl << rmem;
		}
	}
	///
	int parse_tcl_command(tcl_args&);
	///
	virtual bool private_data(const cpp_private& data) const {
		return (data == (cpp_mptr)gather_info());
	}
	///
	void connect(cpp_mem*) {}
	///
	void disconnect(void) {}
	
  protected:
	///
	virtual cpp_data_gatherptr gather_info(void) const=0;
};

template <class T>
class member_gatherer_t : public member_gatherer {
	friend class cpp_member_info;
  protected:
    ///
	cpp_mem* copy(void) const {return new member_gatherer_t<T>(*this);}
	///
	member_gatherer_t(const member_gatherer_t<T>& c):member_gatherer(c),
		gather_info_(c.gather_info_) {}
	///
	cpp_data_gatherer& gatherer(void) const { return container->*gather_info_;}
  public:
	///
	member_gatherer_t(const char* n, cpp_data_gatherer_t<T> (tcl_object::*f))
		:member_gatherer(n),gather_info_(f) {}
	~member_gatherer_t(void) {}
    ///
    
	static const char* _data_type;
    ///
	const char* data_type(void) const { return _data_type;}
    ///
	void tcl_set(tcl_object* o, tcl_args_reader& t) const;
  protected:
	///
	virtual cpp_data_gatherptr gather_info(void) const { 
		return (cpp_data_gatherptr)gather_info_;
	}
	typedef cpp_data_gatherer_t<T> (tcl_object::*gather_ptr);
  private:
	///
    const gather_ptr gather_info_;
};

#define gather_mem(T) (cpp_data_gatherer_t<T> (tcl_object::*))


#endif
